/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.registration;

import android.content.Context;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import io.adaptivecards.objectmodel.AdaptiveCard;
import io.adaptivecards.objectmodel.AdaptiveCardObjectModel;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.BaseCardElementVector;
import io.adaptivecards.objectmodel.CardElementType;
import io.adaptivecards.objectmodel.Column;
import io.adaptivecards.objectmodel.Container;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.VerticalContentAlignment;
import io.adaptivecards.renderer.ActionLayoutRenderer;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.IActionLayoutRenderer;
import io.adaptivecards.renderer.IBaseActionElementRenderer;
import io.adaptivecards.renderer.IBaseCardElementRenderer;
import io.adaptivecards.renderer.IOnlineImageLoader;
import io.adaptivecards.renderer.IOnlineMediaLoader;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.action.ActionElementRenderer;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.input.ChoiceSetInputRenderer;
import io.adaptivecards.renderer.input.DateInputRenderer;
import io.adaptivecards.renderer.input.NumberInputRenderer;
import io.adaptivecards.renderer.input.TextInputRenderer;
import io.adaptivecards.renderer.input.TimeInputRenderer;
import io.adaptivecards.renderer.input.ToggleInputRenderer;
import io.adaptivecards.renderer.inputhandler.IInputWatcher;
import io.adaptivecards.renderer.readonly.ColumnRenderer;
import io.adaptivecards.renderer.readonly.ColumnSetRenderer;
import io.adaptivecards.renderer.readonly.ContainerRenderer;
import io.adaptivecards.renderer.readonly.FactSetRenderer;
import io.adaptivecards.renderer.readonly.ImageRenderer;
import io.adaptivecards.renderer.readonly.ImageSetRenderer;
import io.adaptivecards.renderer.readonly.MediaRenderer;
import io.adaptivecards.renderer.readonly.TextBlockRenderer;
import java.util.HashMap;

public class CardRendererRegistration {
    private static CardRendererRegistration s_instance = null;
    private IInputWatcher m_InputWatcher = null;
    private HashMap<String, IBaseCardElementRenderer> m_typeToRendererMap = new HashMap();
    private IBaseActionElementRenderer m_actionRenderer = null;
    private IActionLayoutRenderer m_actionLayoutRenderer = null;
    private IOnlineImageLoader m_onlineImageLoader = null;
    private IOnlineMediaLoader m_onlineMediaLoader = null;

    private CardRendererRegistration() {
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.Column), ColumnRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.ColumnSet), ColumnSetRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.Container), ContainerRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.FactSet), FactSetRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.Image), ImageRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.ImageSet), ImageSetRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.Media), MediaRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.TextBlock), TextBlockRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.TextInput), TextInputRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.NumberInput), NumberInputRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.DateInput), DateInputRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.TimeInput), TimeInputRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.ToggleInput), ToggleInputRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.ChoiceSetInput), ChoiceSetInputRenderer.getInstance());
        this.m_actionRenderer = ActionElementRenderer.getInstance();
        this.m_actionLayoutRenderer = ActionLayoutRenderer.getInstance();
    }

    public static CardRendererRegistration getInstance() {
        if (s_instance == null) {
            s_instance = new CardRendererRegistration();
        }
        return s_instance;
    }

    public void registerRenderer(String cardElementType, IBaseCardElementRenderer renderer) {
        if (TextUtils.isEmpty((CharSequence)cardElementType) || CardElementType.Unsupported.toString().equals(cardElementType)) {
            throw new IllegalArgumentException("cardElementType is null or unsupported");
        }
        if (renderer == null) {
            throw new IllegalArgumentException("renderer is null");
        }
        this.m_typeToRendererMap.put(cardElementType, renderer);
    }

    public IBaseCardElementRenderer getRenderer(String cardElementType) {
        return this.m_typeToRendererMap.get(cardElementType);
    }

    public void setInputWatcher(IInputWatcher inputWatcher) {
        this.m_InputWatcher = inputWatcher;
    }

    public IInputWatcher getInputWatcher() {
        return this.m_InputWatcher;
    }

    public void notifyInputChange(String id, String value) {
        if (this.m_InputWatcher != null) {
            this.m_InputWatcher.onInputChange(id, value);
        }
    }

    public void registerOnlineImageLoader(IOnlineImageLoader imageLoader) {
        this.m_onlineImageLoader = imageLoader;
    }

    public IOnlineImageLoader getOnlineImageLoader() {
        return this.m_onlineImageLoader;
    }

    public void registerActionRenderer(IBaseActionElementRenderer actionRenderer) {
        this.m_actionRenderer = actionRenderer;
    }

    public IBaseActionElementRenderer getActionRenderer() {
        return this.m_actionRenderer;
    }

    public void registerActionLayoutRenderer(IActionLayoutRenderer actionLayoutRenderer) {
        this.m_actionLayoutRenderer = actionLayoutRenderer;
    }

    public IOnlineMediaLoader getOnlineMediaLoader() {
        return this.m_onlineMediaLoader;
    }

    public void registerOnlineMediaLoader(IOnlineMediaLoader onlineMediaLoader) {
        this.m_onlineMediaLoader = onlineMediaLoader;
    }

    public IActionLayoutRenderer getActionLayoutRenderer() {
        return this.m_actionLayoutRenderer;
    }

    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, Object tag, BaseCardElementVector baseCardElementList, ICardActionHandler cardActionHandler, HostConfig hostConfig, ContainerStyle containerStyle) {
        long size;
        if (baseCardElementList == null || (size = baseCardElementList.size()) <= 0L) {
            return viewGroup;
        }
        LinearLayout layout2 = new LinearLayout(context);
        layout2.setTag(tag);
        layout2.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        layout2.setOrientation(1);
        VerticalContentAlignment verticalContentAlignment = VerticalContentAlignment.Top;
        if (tag instanceof BaseCardElement) {
            if (tag instanceof Column) {
                Column column = (Column)tag;
                verticalContentAlignment = column.GetVerticalContentAlignment();
            } else if (tag instanceof Container) {
                Container container = (Container)tag;
                verticalContentAlignment = container.GetVerticalContentAlignment();
            }
        } else if (tag instanceof AdaptiveCard) {
            AdaptiveCard adaptiveCard = (AdaptiveCard)tag;
            verticalContentAlignment = adaptiveCard.GetVerticalContentAlignment();
        }
        if (verticalContentAlignment != VerticalContentAlignment.Top) {
            LinearLayout verticalAlignmentLayout = new LinearLayout(context);
            verticalAlignmentLayout.setOrientation(0);
            verticalAlignmentLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
            layout2.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            if (verticalContentAlignment == VerticalContentAlignment.Center) {
                verticalAlignmentLayout.setGravity(16);
            } else {
                verticalAlignmentLayout.setGravity(80);
            }
            verticalAlignmentLayout.addView((View)layout2);
            if (viewGroup != null) {
                viewGroup.addView((View)verticalAlignmentLayout);
            }
        } else if (viewGroup != null) {
            viewGroup.addView((View)layout2);
        }
        int i = 0;
        while ((long)i < size) {
            BaseCardElement cardElement = baseCardElementList.get(i);
            IBaseCardElementRenderer renderer = this.m_typeToRendererMap.get(cardElement.GetElementTypeString());
            if (renderer == null) {
                renderedCard.addWarning(new AdaptiveWarning(1, "Unsupported card element type: " + cardElement.GetElementTypeString()));
            } else {
                renderer.render(renderedCard, context, fragmentManager, (ViewGroup)layout2, cardElement, cardActionHandler, hostConfig, containerStyle);
            }
            ++i;
        }
        return layout2;
    }
}

