/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import io.adaptivecards.objectmodel.ActionAlignment;
import io.adaptivecards.objectmodel.ActionsOrientation;
import io.adaptivecards.objectmodel.BaseActionElement;
import io.adaptivecards.objectmodel.BaseActionElementVector;
import io.adaptivecards.objectmodel.BaseElement;
import io.adaptivecards.objectmodel.FallbackType;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.IconPlacement;
import io.adaptivecards.objectmodel.Spacing;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.IActionLayoutRenderer;
import io.adaptivecards.renderer.IBaseActionElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.registration.CardRendererRegistration;

public class ActionLayoutRenderer
implements IActionLayoutRenderer {
    private static ActionLayoutRenderer s_instance = null;

    protected ActionLayoutRenderer() {
    }

    public static ActionLayoutRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ActionLayoutRenderer();
        }
        return s_instance;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void renderActions(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseActionElementVector baseActionElementList, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) {
        BaseActionElement actionElement;
        long size;
        if (baseActionElementList == null || (size = (long)baseActionElementList.size()) <= 0L) {
            return;
        }
        LinearLayout actionButtonsLayout = new LinearLayout(context);
        actionButtonsLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        int alignment = hostConfig.GetActions().getActionAlignment().swigValue();
        int actionButtonsAlignment = 0x800033;
        if (alignment == ActionAlignment.Right.swigValue()) {
            actionButtonsAlignment = 5;
        } else if (alignment == ActionAlignment.Center.swigValue()) {
            actionButtonsAlignment = 1;
        }
        actionButtonsLayout.setGravity(actionButtonsAlignment);
        int actionButtonsLayoutOrientation = hostConfig.GetActions().getActionsOrientation().swigValue();
        if (actionButtonsLayoutOrientation == ActionsOrientation.Vertical.swigValue()) {
            actionButtonsLayout.setOrientation(1);
        } else {
            actionButtonsLayout.setOrientation(0);
        }
        Spacing spacing = hostConfig.GetActions().getSpacing();
        BaseCardElementRenderer.setSpacingAndSeparator(context, viewGroup, spacing, false, hostConfig, true);
        if (viewGroup != null) {
            if (actionButtonsLayoutOrientation == ActionsOrientation.Horizontal.swigValue()) {
                HorizontalScrollView actionButtonsContainer = new HorizontalScrollView(context);
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
                layoutParams.gravity = actionButtonsAlignment;
                actionButtonsContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                actionButtonsContainer.setHorizontalScrollBarEnabled(false);
                actionButtonsContainer.addView((View)actionButtonsLayout);
                viewGroup.addView((View)actionButtonsContainer);
            } else {
                viewGroup.addView((View)actionButtonsLayout);
            }
        }
        int i = 0;
        long maxActions = hostConfig.GetActions().getMaxActions();
        boolean allActionsHaveIcons = true;
        while ((long)i < size && (long)i < maxActions) {
            actionElement = baseActionElementList.get(i);
            if (actionElement.GetIconUrl().isEmpty()) {
                allActionsHaveIcons = false;
                break;
            }
            ++i;
        }
        i = 0;
        while (true) {
            block24: {
                IconPlacement originalIconPlacement;
                block21: {
                    BaseElement fallbackElement;
                    block23: {
                        block20: {
                            block22: {
                                boolean elementHasFallback;
                                if ((long)i >= size || (long)i >= maxActions) break block20;
                                actionElement = baseActionElementList.get(i);
                                originalIconPlacement = hostConfig.GetActions().getIconPlacement();
                                if (!allActionsHaveIcons) {
                                    hostConfig.GetActions().setIconPlacement(IconPlacement.LeftOfTitle);
                                }
                                IBaseActionElementRenderer actionRenderer = CardRendererRegistration.getInstance().getActionRenderer(actionElement.GetElementTypeString());
                                Button returnedView = null;
                                if (actionRenderer != null) {
                                    returnedView = actionRenderer.render(renderedCard, context, fragmentManager, (ViewGroup)actionButtonsLayout, actionElement, cardActionHandler, hostConfig, renderArgs);
                                }
                                boolean bl = elementHasFallback = actionElement.GetFallbackType() != FallbackType.None;
                                if (actionRenderer != null && returnedView != null) break block21;
                                if (!elementHasFallback) break block22;
                                if (actionElement.GetFallbackType() != FallbackType.Content) break block21;
                                fallbackElement = actionElement.GetFallbackContent();
                                break block23;
                            }
                            renderedCard.addWarning(new AdaptiveWarning(1, "Unsupported card element type: " + actionElement.GetElementTypeString()));
                            break block24;
                        }
                        if ((long)i >= maxActions && size != maxActions) {
                            renderedCard.addWarning(new AdaptiveWarning(4, "A maximum of " + maxActions + " actions are allowed"));
                        }
                        return;
                    }
                    while (fallbackElement != null) {
                        BaseActionElement fallbackActionElement = null;
                        if (fallbackElement instanceof BaseActionElement) {
                            fallbackActionElement = (BaseActionElement)fallbackElement;
                        } else {
                            fallbackActionElement = BaseActionElement.dynamic_cast(fallbackElement);
                            if (fallbackActionElement == null) {
                                throw new InternalError("Unable to convert BaseElement to BaseActionElement object model.");
                            }
                        }
                        IBaseActionElementRenderer fallbackActionRenderer = CardRendererRegistration.getInstance().getActionRenderer(fallbackActionElement.GetElementTypeString());
                        if (fallbackActionRenderer != null) {
                            fallbackActionRenderer.render(renderedCard, context, fragmentManager, (ViewGroup)actionButtonsLayout, fallbackActionElement, cardActionHandler, hostConfig, renderArgs);
                            break;
                        }
                        if (fallbackActionElement.GetFallbackType() != FallbackType.Content) continue;
                        fallbackElement = fallbackActionElement.GetFallbackContent();
                    }
                }
                hostConfig.GetActions().setIconPlacement(originalIconPlacement);
            }
            ++i;
        }
    }
}

