/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.widget.LinearLayout;
import io.adaptivecards.objectmodel.BackgroundImage;
import io.adaptivecards.renderer.GenericImageLoaderAsync;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.http.HttpRequestResult;

public class BackgroundImageLoaderAsync
extends GenericImageLoaderAsync {
    private Context m_context;
    private LinearLayout m_layout;
    private BackgroundImage m_backgroundImageProperties;

    public BackgroundImageLoaderAsync(RenderedAdaptiveCard renderedCard, Context context, LinearLayout layout, String imageBaseUrl, int maxWidth, BackgroundImage backgroundImageProperties) {
        super(renderedCard, imageBaseUrl, maxWidth);
        this.m_context = context;
        this.m_layout = layout;
        this.m_backgroundImageProperties = backgroundImageProperties;
    }

    protected HttpRequestResult<Bitmap> doInBackground(String ... args) {
        if (args.length == 0) {
            return null;
        }
        return this.loadImage(args[0], this.m_context);
    }

    @Override
    void onSuccessfulPostExecute(Bitmap bitmap) {
        BackgroundImageDrawable background = new BackgroundImageDrawable(this.m_context.getResources(), bitmap, this.m_backgroundImageProperties);
        this.m_layout.setBackground((Drawable)background);
        this.m_layout.bringChildToFront(this.m_layout.getChildAt(0));
    }

    private class BackgroundImageDrawable
    extends BitmapDrawable {
        private BackgroundImage m_backgroundImageProperties;

        public BackgroundImageDrawable(Resources resources, Bitmap bitmap, BackgroundImage backgroundImageProperties) {
            super(resources, bitmap);
            this.m_backgroundImageProperties = backgroundImageProperties;
        }

        public void draw(Canvas canvas) {
            switch (this.m_backgroundImageProperties.GetMode()) {
                case Repeat: {
                    this.setTileModeXY(Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
                    super.draw(canvas);
                    break;
                }
                case RepeatVertically: {
                    this.tileVertically(canvas);
                    break;
                }
                case RepeatHorizontally: {
                    this.tileHorizontally(canvas);
                    break;
                }
                default: {
                    super.draw(canvas);
                }
            }
        }

        private void tileHorizontally(Canvas canvas) {
            float verticalOffset;
            switch (this.m_backgroundImageProperties.GetVerticalAlignment()) {
                case Bottom: {
                    verticalOffset = canvas.getHeight() - this.getBitmap().getHeight();
                    break;
                }
                case Center: {
                    verticalOffset = (float)(canvas.getHeight() - this.getBitmap().getHeight()) / 2.0f;
                    break;
                }
                default: {
                    verticalOffset = 0.0f;
                }
            }
            for (int x = 0; x < canvas.getWidth(); x += this.getBitmap().getWidth()) {
                canvas.drawBitmap(this.getBitmap(), (float)x, verticalOffset, this.getPaint());
            }
        }

        private void tileVertically(Canvas canvas) {
            float horizontalOffset;
            switch (this.m_backgroundImageProperties.GetHorizontalAlignment()) {
                case Right: {
                    horizontalOffset = canvas.getWidth() - this.getBitmap().getWidth();
                    break;
                }
                case Center: {
                    horizontalOffset = (float)(canvas.getWidth() - this.getBitmap().getWidth()) / 2.0f;
                    break;
                }
                default: {
                    horizontalOffset = 0.0f;
                }
            }
            for (int y = 0; y < canvas.getHeight(); y += this.getBitmap().getHeight()) {
                canvas.drawBitmap(this.getBitmap(), horizontalOffset, (float)y, this.getPaint());
            }
        }
    }
}

