/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.Spacing;
import io.adaptivecards.objectmodel.SpacingConfig;
import io.adaptivecards.renderer.IBaseCardElementRenderer;
import io.adaptivecards.renderer.Util;

public abstract class BaseCardElementRenderer
implements IBaseCardElementRenderer {
    protected static long getSpacingSize(Spacing spacing, SpacingConfig defaultSpacingConfig) {
        long spacingSize = 0L;
        if (spacing == Spacing.None) {
            return 0L;
        }
        if (spacing == Spacing.Default) {
            spacingSize = defaultSpacingConfig.getDefaultSpacing();
        } else if (spacing == Spacing.ExtraLarge) {
            spacingSize = defaultSpacingConfig.getExtraLargeSpacing();
        } else if (spacing == Spacing.Large) {
            spacingSize = defaultSpacingConfig.getLargeSpacing();
        } else if (spacing == Spacing.Medium) {
            spacingSize = defaultSpacingConfig.getMediumSpacing();
        } else if (spacing == Spacing.Small) {
            spacingSize = defaultSpacingConfig.getSmallSpacing();
        } else if (spacing == Spacing.Padding) {
            spacingSize = defaultSpacingConfig.getPaddingSpacing();
        } else {
            throw new IllegalArgumentException("Unknown spacing style: " + spacing.toString());
        }
        return (int)spacingSize;
    }

    protected static int getColor(String colorCode) {
        return Color.parseColor((String)colorCode);
    }

    protected static void setSpacingAndSeparator(Context context, ViewGroup viewGroup, Spacing spacing, boolean separator, HostConfig hostConfig, boolean horizontalLine, boolean isImageSet) {
        LinearLayout.LayoutParams params;
        if (viewGroup.getChildCount() <= 0) {
            return;
        }
        int spacingSize = Util.dpToPixels(context, BaseCardElementRenderer.getSpacingSize(spacing, hostConfig.GetSpacing()));
        int separatorThickness = Util.dpToPixels(context, hostConfig.GetSeparator().getLineThickness());
        int separatorColor = Color.parseColor((String)hostConfig.GetSeparator().getLineColor());
        ImageView view = new ImageView(context);
        if (separator && separatorThickness > 0) {
            view.setBackgroundColor(separatorColor);
            params = new LinearLayout.LayoutParams(horizontalLine ? -1 : separatorThickness, horizontalLine ? separatorThickness : -1);
            params.setMargins(horizontalLine ? 0 : spacingSize / 2, horizontalLine ? spacingSize / 2 : 0, horizontalLine ? 0 : spacingSize / 2, horizontalLine ? spacingSize / 2 : 0);
        } else {
            params = new LinearLayout.LayoutParams(horizontalLine ? -1 : spacingSize, horizontalLine ? spacingSize : (isImageSet ? 0 : -1));
        }
        view.setLayoutParams((ViewGroup.LayoutParams)params);
        viewGroup.addView((View)view);
    }

    protected static void setSpacingAndSeparator(Context context, ViewGroup viewGroup, Spacing spacing, boolean separator, HostConfig hostConfig, boolean horizontalLine) {
        BaseCardElementRenderer.setSpacingAndSeparator(context, viewGroup, spacing, separator, hostConfig, horizontalLine, false);
    }
}

