/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.inputhandler;

import android.support.v4.app.FragmentManager;
import android.widget.EditText;
import io.adaptivecards.objectmodel.BaseInputElement;
import io.adaptivecards.renderer.inputhandler.TextInputHandler;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimeInputHandler
extends TextInputHandler {
    private FragmentManager m_fragmentManager;
    public static final String TIME_FORMAT_SUBMIT = "kk:mm";
    public static SimpleDateFormat s_simpleDateFormat = new SimpleDateFormat("kk:mm");

    public TimeInputHandler(BaseInputElement baseInputElement, FragmentManager fragmentManager) {
        super(baseInputElement);
        this.m_fragmentManager = fragmentManager;
    }

    public FragmentManager getFragmentManager() {
        return this.m_fragmentManager;
    }

    @Override
    public String getInput() {
        EditText editText = this.getEditText();
        try {
            Date time = DateFormat.getTimeInstance().parse(editText.getText().toString());
            return s_simpleDateFormat.format(time);
        }
        catch (ParseException e) {
            return editText.getText().toString();
        }
    }
}

