/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.graphics.Color;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import io.adaptivecards.objectmodel.BackgroundImage;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.Column;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.VerticalContentAlignment;
import io.adaptivecards.renderer.BackgroundImageLoaderAsync;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.action.ActionElementRenderer;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.registration.CardRendererRegistration;
import java.util.Locale;

public class ColumnRenderer
extends BaseCardElementRenderer {
    private static ColumnRenderer s_instance = null;
    private final String g_columnSizeAuto = "auto";
    private final String g_columnSizeStretch = "stretch";
    private boolean m_isRenderingFirstColumn = false;
    private boolean m_isRenderingLastColumn = false;

    protected ColumnRenderer() {
    }

    public static ColumnRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ColumnRenderer();
        }
        return s_instance;
    }

    public void setIsRenderingFirstColumn(boolean isRenderingFirstColumn) {
        this.m_isRenderingFirstColumn = isRenderingFirstColumn;
    }

    public void setIsRenderingLastColumn(boolean isRenderingLastColumn) {
        this.m_isRenderingLastColumn = isRenderingLastColumn;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) {
        LinearLayout.LayoutParams layoutParams;
        BackgroundImage backgroundImageProperties;
        View v;
        Column column;
        if (baseCardElement instanceof Column) {
            column = (Column)baseCardElement;
        } else {
            column = Column.dynamic_cast(baseCardElement);
            if (column == null) {
                throw new InternalError("Unable to convert BaseCardElement to FactSet object model.");
            }
        }
        ColumnRenderer.setSpacingAndSeparator(context, viewGroup, column.GetSpacing(), column.GetSeparator(), hostConfig, false);
        ContainerStyle styleForThis = column.GetStyle().swigValue() == ContainerStyle.None.swigValue() ? renderArgs.getContainerStyle() : column.GetStyle();
        LinearLayout returnedView = new LinearLayout(context);
        returnedView.setOrientation(1);
        returnedView.setTag((Object)new TagContent(column));
        returnedView.setClipChildren(false);
        returnedView.setClipToPadding(false);
        if (!baseCardElement.GetIsVisible()) {
            returnedView.setVisibility(8);
        }
        LinearLayout verticalContentAlignmentLayout = new LinearLayout(context);
        verticalContentAlignmentLayout.setOrientation(0);
        verticalContentAlignmentLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        VerticalContentAlignment contentAlignment = column.GetVerticalContentAlignment();
        switch (contentAlignment) {
            case Center: {
                verticalContentAlignmentLayout.setGravity(16);
                break;
            }
            case Bottom: {
                verticalContentAlignmentLayout.setGravity(80);
                break;
            }
            default: {
                verticalContentAlignmentLayout.setGravity(48);
            }
        }
        returnedView.addView((View)verticalContentAlignmentLayout);
        RenderArgs renderArgs1 = new RenderArgs(renderArgs);
        renderArgs1.setContainerStyle(styleForThis);
        if (!column.GetItems().isEmpty() && (v = CardRendererRegistration.getInstance().render(renderedCard, context, fragmentManager, (ViewGroup)verticalContentAlignmentLayout, column, column.GetItems(), cardActionHandler, hostConfig, renderArgs1)) == null) {
            return null;
        }
        if (styleForThis != renderArgs.getContainerStyle()) {
            int padding = Util.dpToPixels(context, hostConfig.GetSpacing().getPaddingSpacing());
            returnedView.setPadding(padding, padding, padding, padding);
            String color = hostConfig.GetBackgroundColor(styleForThis);
            returnedView.setBackgroundColor(Color.parseColor((String)color));
        }
        if ((backgroundImageProperties = column.GetBackgroundImage()) != null && !backgroundImageProperties.GetUrl().isEmpty()) {
            BackgroundImageLoaderAsync loaderAsync = new BackgroundImageLoaderAsync(renderedCard, context, returnedView, hostConfig.GetImageBaseUrl(), context.getResources().getDisplayMetrics().widthPixels, backgroundImageProperties);
            loaderAsync.execute(new String[]{backgroundImageProperties.GetUrl()});
        }
        String columnSize = column.GetWidth().toLowerCase(Locale.getDefault());
        long pixelWidth = column.GetPixelWidth();
        if (pixelWidth != 0L) {
            layoutParams = new LinearLayout.LayoutParams(-1, -1);
            layoutParams.width = Util.dpToPixels(context, pixelWidth);
            returnedView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        } else if (TextUtils.isEmpty((CharSequence)columnSize) || columnSize.equals("stretch")) {
            layoutParams = new LinearLayout.LayoutParams(-1, -1);
            layoutParams.weight = 1.0f;
            returnedView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        } else if (columnSize.equals("auto")) {
            layoutParams = new LinearLayout.LayoutParams(-2, -1);
            returnedView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        } else {
            try {
                float columnWeight = Float.parseFloat(columnSize);
                layoutParams = new LinearLayout.LayoutParams(-1, -1);
                layoutParams.width = 0;
                layoutParams.weight = columnWeight;
                returnedView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
            catch (NumberFormatException numFormatExcep) {
                throw new IllegalArgumentException("Column Width (" + column.GetWidth() + ") is not a valid weight ('auto', 'stretch', <integer>).");
            }
        }
        if (column.GetBleed() && column.GetCanBleed()) {
            long padding = Util.dpToPixels(context, hostConfig.GetSpacing().getPaddingSpacing());
            int leftPadding = 0;
            int rightPadding = 0;
            if (this.m_isRenderingFirstColumn) {
                leftPadding = (int)(-padding);
                this.setIsRenderingFirstColumn(false);
            }
            if (this.m_isRenderingLastColumn) {
                rightPadding = (int)(-padding);
                this.setIsRenderingLastColumn(false);
            }
            layoutParams.setMargins(leftPadding, 0, rightPadding, 0);
            returnedView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        if (column.GetSelectAction() != null) {
            returnedView.setClickable(true);
            returnedView.setOnClickListener((View.OnClickListener)new ActionElementRenderer.ButtonOnClickListener(renderedCard, column.GetSelectAction(), cardActionHandler));
        }
        if (column.GetMinHeight() != 0L) {
            returnedView.setMinimumHeight(Util.dpToPixels(context, (int)column.GetMinHeight()));
        }
        viewGroup.addView((View)returnedView);
        return returnedView;
    }
}

