/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.graphics.Color;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.CardElementType;
import io.adaptivecards.objectmodel.Column;
import io.adaptivecards.objectmodel.ColumnSet;
import io.adaptivecards.objectmodel.ColumnVector;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.HeightType;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.IBaseCardElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.action.ActionElementRenderer;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.readonly.ColumnRenderer;
import io.adaptivecards.renderer.registration.CardRendererRegistration;

public class ColumnSetRenderer
extends BaseCardElementRenderer {
    private static ColumnSetRenderer s_instance = null;

    protected ColumnSetRenderer() {
    }

    public static ColumnSetRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ColumnSetRenderer();
        }
        return s_instance;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) {
        ColumnSet columnSet = null;
        if (baseCardElement instanceof ColumnSet) {
            columnSet = (ColumnSet)baseCardElement;
        } else {
            columnSet = ColumnSet.dynamic_cast(baseCardElement);
            if (columnSet == null) {
                throw new InternalError("Unable to convert BaseCardElement to ColumnSet object model.");
            }
        }
        IBaseCardElementRenderer columnRenderer = CardRendererRegistration.getInstance().getRenderer(CardElementType.Column.toString());
        if (columnRenderer == null) {
            throw new UnknownError(CardElementType.Column.toString() + " is not a registered renderer.");
        }
        ColumnSetRenderer.setSpacingAndSeparator(context, viewGroup, columnSet.GetSpacing(), columnSet.GetSeparator(), hostConfig, true);
        ContainerStyle styleForThis = columnSet.GetStyle().swigValue() == ContainerStyle.None.swigValue() ? renderArgs.getContainerStyle() : columnSet.GetStyle();
        ColumnVector columnVector = columnSet.GetColumns();
        long columnVectorSize = columnVector.size();
        LinearLayout layout2 = new LinearLayout(context);
        layout2.setTag((Object)new TagContent(columnSet));
        layout2.setClipChildren(false);
        layout2.setClipToPadding(false);
        if (!baseCardElement.GetIsVisible()) {
            layout2.setVisibility(8);
        }
        ContainerStyle containerStyle = renderArgs.getContainerStyle();
        int i = 0;
        while ((long)i < columnVectorSize) {
            View v;
            Column column = columnVector.get(i);
            ColumnRenderer rendererAsColumnRenderer = null;
            if (columnRenderer instanceof ColumnRenderer) {
                rendererAsColumnRenderer = (ColumnRenderer)columnRenderer;
                rendererAsColumnRenderer.setIsRenderingFirstColumn(i == 0);
                rendererAsColumnRenderer.setIsRenderingLastColumn((long)i == columnVectorSize - 1L);
            }
            if ((v = columnRenderer.render(renderedCard, context, fragmentManager, (ViewGroup)layout2, column, cardActionHandler, hostConfig, renderArgs)) == null) {
                return null;
            }
            ++i;
        }
        if (columnSet.GetSelectAction() != null) {
            layout2.setClickable(true);
            layout2.setOnClickListener((View.OnClickListener)new ActionElementRenderer.ButtonOnClickListener(renderedCard, columnSet.GetSelectAction(), cardActionHandler));
        }
        if (columnSet.GetHeight() == HeightType.Stretch) {
            LinearLayout stretchLayout = new LinearLayout(context);
            stretchLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
            stretchLayout.setOrientation(1);
            layout2.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
            stretchLayout.addView((View)layout2);
            viewGroup.addView((View)stretchLayout);
        } else {
            layout2.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            viewGroup.addView((View)layout2);
        }
        if (columnSet.GetBleed() && (columnSet.GetCanBleed() || styleForThis != containerStyle || columnSet.GetBackgroundImage() != null)) {
            long padding = Util.dpToPixels(context, hostConfig.GetSpacing().getPaddingSpacing());
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)layout2.getLayoutParams();
            layoutParams.setMargins((int)(-padding), layoutParams.topMargin, (int)(-padding), layoutParams.bottomMargin);
            layout2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        if (styleForThis != containerStyle) {
            int padding = Util.dpToPixels(context, hostConfig.GetSpacing().getPaddingSpacing());
            layout2.setPadding(padding, padding, padding, padding);
            String color = styleForThis == ContainerStyle.Emphasis ? hostConfig.GetContainerStyles().getEmphasisPalette().getBackgroundColor() : hostConfig.GetContainerStyles().getDefaultPalette().getBackgroundColor();
            layout2.setBackgroundColor(Color.parseColor((String)color));
        }
        if (columnSet.GetMinHeight() != 0L) {
            layout2.setMinimumHeight(Util.dpToPixels(context, (int)columnSet.GetMinHeight()));
        }
        return layout2;
    }
}

