/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.graphics.Color;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import io.adaptivecards.objectmodel.BackgroundImage;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.Container;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.HeightType;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.VerticalContentAlignment;
import io.adaptivecards.renderer.BackgroundImageLoaderAsync;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.action.ActionElementRenderer;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.registration.CardRendererRegistration;

public class ContainerRenderer
extends BaseCardElementRenderer {
    private static ContainerRenderer s_instance = null;

    protected ContainerRenderer() {
    }

    public static ContainerRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ContainerRenderer();
        }
        return s_instance;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) {
        BackgroundImage backgroundImageProperties;
        View v;
        Container container = null;
        if (baseCardElement instanceof Container) {
            container = (Container)baseCardElement;
        } else {
            container = Container.dynamic_cast(baseCardElement);
            if (container == null) {
                throw new InternalError("Unable to convert BaseCardElement to Container object model.");
            }
        }
        ContainerStyle containerStyle = renderArgs.getContainerStyle();
        ContainerRenderer.setSpacingAndSeparator(context, viewGroup, container.GetSpacing(), container.GetSeparator(), hostConfig, true);
        ContainerStyle styleForThis = container.GetStyle().swigValue() == ContainerStyle.None.swigValue() ? containerStyle : container.GetStyle();
        LinearLayout containerView = new LinearLayout(context);
        containerView.setTag((Object)new TagContent(container));
        containerView.setClipChildren(false);
        containerView.setClipToPadding(false);
        if (!baseCardElement.GetIsVisible()) {
            containerView.setVisibility(8);
        }
        containerView.setOrientation(1);
        if (container.GetHeight() == HeightType.Stretch) {
            containerView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        } else {
            containerView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        }
        VerticalContentAlignment contentAlignment = container.GetVerticalContentAlignment();
        switch (contentAlignment) {
            case Center: {
                containerView.setGravity(16);
                break;
            }
            case Bottom: {
                containerView.setGravity(80);
                break;
            }
            default: {
                containerView.setGravity(48);
            }
        }
        if (!container.GetItems().isEmpty() && (v = CardRendererRegistration.getInstance().render(renderedCard, context, fragmentManager, (ViewGroup)containerView, container, container.GetItems(), cardActionHandler, hostConfig, renderArgs)) == null) {
            return null;
        }
        if (styleForThis != containerStyle) {
            int padding = Util.dpToPixels(context, hostConfig.GetSpacing().getPaddingSpacing());
            containerView.setPadding(padding, padding, padding, padding);
            String color = hostConfig.GetBackgroundColor(styleForThis);
            containerView.setBackgroundColor(Color.parseColor((String)color));
        }
        if ((backgroundImageProperties = container.GetBackgroundImage()) != null && !backgroundImageProperties.GetUrl().isEmpty()) {
            BackgroundImageLoaderAsync loaderAsync = new BackgroundImageLoaderAsync(renderedCard, context, containerView, hostConfig.GetImageBaseUrl(), context.getResources().getDisplayMetrics().widthPixels, backgroundImageProperties);
            loaderAsync.execute(new String[]{backgroundImageProperties.GetUrl()});
        }
        if (container.GetBleed() && (container.GetCanBleed() || styleForThis != containerStyle || container.GetBackgroundImage() != null)) {
            long padding = Util.dpToPixels(context, hostConfig.GetSpacing().getPaddingSpacing());
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)containerView.getLayoutParams();
            layoutParams.setMargins((int)(-padding), layoutParams.topMargin, (int)(-padding), layoutParams.bottomMargin);
            containerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        if (container.GetSelectAction() != null) {
            containerView.setClickable(true);
            containerView.setOnClickListener((View.OnClickListener)new ActionElementRenderer.ButtonOnClickListener(renderedCard, container.GetSelectAction(), cardActionHandler));
        }
        if (container.GetMinHeight() != 0L) {
            containerView.setMinimumHeight(Util.dpToPixels(context, (int)container.GetMinHeight()));
        }
        viewGroup.addView((View)containerView);
        return containerView;
    }
}

