/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Shader;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.HeightType;
import io.adaptivecards.objectmodel.HorizontalAlignment;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.Image;
import io.adaptivecards.objectmodel.ImageSize;
import io.adaptivecards.objectmodel.ImageSizesConfig;
import io.adaptivecards.objectmodel.ImageStyle;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.IOnlineImageLoader;
import io.adaptivecards.renderer.InnerImageLoaderAsync;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.action.ActionElementRenderer;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.layout.HorizontalFlowLayout;
import io.adaptivecards.renderer.registration.CardRendererRegistration;

public class ImageRenderer
extends BaseCardElementRenderer {
    private static ImageRenderer s_instance = null;

    protected ImageRenderer() {
    }

    public static ImageRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ImageRenderer();
        }
        return s_instance;
    }

    private static int getImageSizeLimit(Context context, ImageSize imageSize, ImageSizesConfig imageSizesConfig) {
        int imageSizeLimit = context.getResources().getDisplayMetrics().widthPixels;
        if (imageSize == ImageSize.Small) {
            imageSizeLimit = Util.dpToPixels(context, imageSizesConfig.getSmallSize());
        } else if (imageSize == ImageSize.Medium) {
            imageSizeLimit = Util.dpToPixels(context, imageSizesConfig.getMediumSize());
        } else if (imageSize == ImageSize.Large) {
            imageSizeLimit = Util.dpToPixels(context, imageSizesConfig.getLargeSize());
        }
        return imageSizeLimit;
    }

    private static void setImageSize(Context context, ImageView imageView, ImageSize imageSize, ImageSizesConfig imageSizesConfig) {
        imageView.setScaleType(ImageView.ScaleType.CENTER);
        if (imageSize == ImageSize.Stretch) {
            imageView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
            imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        } else if (imageSize == ImageSize.Small) {
            imageView.setMaxWidth(Util.dpToPixels(context, imageSizesConfig.getSmallSize()));
        } else if (imageSize == ImageSize.Medium) {
            imageView.setMaxWidth(Util.dpToPixels(context, imageSizesConfig.getMediumSize()));
        } else if (imageSize == ImageSize.Large) {
            imageView.setMaxWidth(Util.dpToPixels(context, imageSizesConfig.getLargeSize()));
        } else if (imageSize != ImageSize.Auto && imageSize != ImageSize.None) {
            throw new IllegalArgumentException("Unknown image size: " + imageSize.toString());
        }
        imageView.setAdjustViewBounds(true);
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) {
        boolean isAspectRatioNeeded;
        Image image;
        if (baseCardElement instanceof Image) {
            image = (Image)baseCardElement;
        } else {
            image = Image.dynamic_cast(baseCardElement);
            if (image == null) {
                throw new InternalError("Unable to convert BaseCardElement to Image object model.");
            }
        }
        ImageView imageView = new ImageView(context);
        imageView.setTag((Object)new TagContent(image));
        if (!baseCardElement.GetIsVisible()) {
            imageView.setVisibility(8);
        }
        String imageBackgroundColor = image.GetBackgroundColor();
        int backgroundColor = 0;
        if (!TextUtils.isEmpty((CharSequence)imageBackgroundColor)) {
            if (imageBackgroundColor.length() == 9 && imageBackgroundColor.charAt(0) == '#') {
                try {
                    backgroundColor = Color.parseColor((String)imageBackgroundColor);
                }
                catch (IllegalArgumentException e) {
                    backgroundColor = 0;
                }
            } else {
                backgroundColor = 0;
            }
        }
        if (image.GetImageStyle() != ImageStyle.Person) {
            imageView.setBackgroundColor(backgroundColor);
        }
        int imageSizeLimit = ImageRenderer.getImageSizeLimit(context, image.GetImageSize(), hostConfig.GetImageSizes());
        ImageRendererImageLoaderAsync imageLoaderAsync = new ImageRendererImageLoaderAsync(renderedCard, imageView, hostConfig.GetImageBaseUrl(), image.GetImageStyle(), backgroundColor, imageSizeLimit);
        IOnlineImageLoader onlineImageLoader = CardRendererRegistration.getInstance().getOnlineImageLoader();
        if (onlineImageLoader != null) {
            imageLoaderAsync.registerCustomOnlineImageLoader(onlineImageLoader);
        }
        imageLoaderAsync.execute(new String[]{image.GetUrl()});
        LinearLayout.LayoutParams layoutParams = image.GetImageSize() == ImageSize.Stretch ? (image.GetHeight() == HeightType.Stretch ? new LinearLayout.LayoutParams(-1, -1, 1.0f) : new LinearLayout.LayoutParams(-1, -2)) : (image.GetHeight() == HeightType.Stretch ? new LinearLayout.LayoutParams(-2, -1, 1.0f) : new LinearLayout.LayoutParams(-2, -2));
        HorizontalAlignment horizontalAlignment = image.GetHorizontalAlignment();
        if (horizontalAlignment == HorizontalAlignment.Right) {
            layoutParams.gravity = 5;
        } else if (horizontalAlignment == HorizontalAlignment.Center) {
            layoutParams.gravity = 1;
        }
        if (image.GetSelectAction() != null) {
            imageView.setClickable(true);
            imageView.setOnClickListener((View.OnClickListener)new ActionElementRenderer.ButtonOnClickListener(renderedCard, image.GetSelectAction(), cardActionHandler));
        }
        imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        long pixelWidth = image.GetPixelWidth();
        long pixelHeight = image.GetPixelHeight();
        boolean hasExplicitSize = pixelHeight != 0L || pixelWidth != 0L;
        boolean bl = isAspectRatioNeeded = pixelHeight == 0L || pixelWidth == 0L;
        if (hasExplicitSize) {
            int widthInPixels = Util.dpToPixels(context, pixelWidth);
            int heightInPixels = Util.dpToPixels(context, pixelHeight);
            if (isAspectRatioNeeded) {
                if (pixelWidth != 0L) {
                    imageView.setMaxWidth(widthInPixels);
                }
                if (pixelHeight != 0L) {
                    imageView.setMaxHeight(heightInPixels);
                }
                imageView.setAdjustViewBounds(true);
            } else {
                imageView.setScaleType(ImageView.ScaleType.FIT_XY);
                imageView.setMaxWidth(widthInPixels);
                imageView.setMaxHeight(heightInPixels);
                imageView.getLayoutParams().height = heightInPixels;
                imageView.getLayoutParams().width = widthInPixels;
            }
        } else {
            ImageRenderer.setImageSize(context, imageView, image.GetImageSize(), hostConfig.GetImageSizes());
        }
        boolean isInImageSet = viewGroup instanceof HorizontalFlowLayout;
        ImageRenderer.setSpacingAndSeparator(context, viewGroup, image.GetSpacing(), image.GetSeparator(), hostConfig, !isInImageSet, isInImageSet);
        if (image.GetMinHeight() != 0L) {
            LinearLayout minHeightLayout = new LinearLayout(context);
            minHeightLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
            minHeightLayout.setMinimumHeight(Util.dpToPixels(context, (int)image.GetMinHeight()));
            minHeightLayout.addView((View)imageView);
            viewGroup.addView((View)minHeightLayout);
        } else {
            viewGroup.addView((View)imageView);
        }
        return imageView;
    }

    private class ImageRendererImageLoaderAsync
    extends InnerImageLoaderAsync {
        private ImageStyle m_imageStyle;
        private int m_backgroundColor;

        ImageRendererImageLoaderAsync(RenderedAdaptiveCard renderedCard, ImageView imageView, String imageBaseUrl, ImageStyle imageStyle, int backgroundColor) {
            this(renderedCard, imageView, imageBaseUrl, imageStyle, backgroundColor, -1);
        }

        ImageRendererImageLoaderAsync(RenderedAdaptiveCard renderedCard, ImageView imageView, String imageBaseUrl, ImageStyle imageStyle, int backgroundColor, int maxWidth) {
            super(renderedCard, (View)imageView, imageBaseUrl, maxWidth);
            this.m_imageStyle = imageStyle;
            this.m_backgroundColor = backgroundColor;
        }

        @Override
        protected Bitmap styleBitmap(Bitmap bitmap) {
            if (bitmap != null && this.m_imageStyle == ImageStyle.Person) {
                Bitmap circleBitmap = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                BitmapShader shader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
                Paint paint = new Paint();
                paint.setShader((Shader)shader);
                Paint backgroundColorPaint = new Paint();
                backgroundColorPaint.setColor(this.m_backgroundColor);
                Canvas c = new Canvas(circleBitmap);
                c.drawCircle((float)(bitmap.getWidth() / 2), (float)(bitmap.getHeight() / 2), (float)(bitmap.getWidth() / 2), backgroundColorPaint);
                c.drawCircle((float)(bitmap.getWidth() / 2), (float)(bitmap.getHeight() / 2), (float)(bitmap.getWidth() / 2), paint);
                bitmap = circleBitmap;
            }
            return bitmap;
        }

        @Override
        protected void renderBitmap(Bitmap bitmap) {
            ImageView view = (ImageView)this.m_view;
            view.setImageBitmap(bitmap);
        }
    }
}

