/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.CardElementType;
import io.adaptivecards.objectmodel.HeightType;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.Image;
import io.adaptivecards.objectmodel.ImageSet;
import io.adaptivecards.objectmodel.ImageSize;
import io.adaptivecards.objectmodel.ImageVector;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.IBaseCardElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.layout.HorizontalFlowLayout;
import io.adaptivecards.renderer.registration.CardRendererRegistration;

public class ImageSetRenderer
extends BaseCardElementRenderer {
    private static ImageSetRenderer s_instance = null;

    protected ImageSetRenderer() {
    }

    public static ImageSetRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ImageSetRenderer();
        }
        return s_instance;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) {
        ImageSet imageSet = null;
        if (baseCardElement instanceof ImageSet) {
            imageSet = (ImageSet)baseCardElement;
        } else {
            imageSet = ImageSet.dynamic_cast(baseCardElement);
            if (imageSet == null) {
                throw new InternalError("Unable to convert BaseCardElement to ImageSet object model.");
            }
        }
        ImageSetRenderer.setSpacingAndSeparator(context, viewGroup, imageSet.GetSpacing(), imageSet.GetSeparator(), hostConfig, true);
        IBaseCardElementRenderer imageRenderer = CardRendererRegistration.getInstance().getRenderer(CardElementType.Image.toString());
        if (imageRenderer == null) {
            throw new IllegalArgumentException("No renderer registered for: " + CardElementType.Image.toString());
        }
        HorizontalFlowLayout horizFlowLayout = new HorizontalFlowLayout(context);
        horizFlowLayout.setTag(new TagContent(imageSet));
        if (!baseCardElement.GetIsVisible()) {
            horizFlowLayout.setVisibility(8);
        }
        ImageSize imageSize = imageSet.GetImageSize();
        ImageVector imageVector = imageSet.GetImages();
        long imageVectorSize = imageVector.size();
        int i = 0;
        while ((long)i < imageVectorSize) {
            Image image = imageVector.get(i);
            image.SetImageSize(imageSize);
            View imageView = imageRenderer.render(renderedCard, context, fragmentManager, (ViewGroup)horizFlowLayout, image, cardActionHandler, hostConfig, renderArgs);
            ((ImageView)imageView).setMaxHeight(Util.dpToPixels(context, hostConfig.GetImageSet().getMaxImageHeight()));
            ++i;
        }
        if (imageSet.GetHeight() == HeightType.Stretch || imageSet.GetMinHeight() != 0L) {
            if (imageSet.GetHeight() == HeightType.Stretch) {
                viewGroup.addView((View)horizFlowLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
            } else {
                LinearLayout minHeightLayout = new LinearLayout(context);
                minHeightLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
                minHeightLayout.setMinimumHeight(Util.dpToPixels(context, (int)imageSet.GetMinHeight()));
                minHeightLayout.addView((View)horizFlowLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
                viewGroup.addView((View)minHeightLayout);
            }
        } else {
            viewGroup.addView((View)horizFlowLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        }
        return horizFlowLayout;
    }
}

