/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.os.Build;
import android.text.Editable;
import android.text.Html;
import android.text.Spanned;
import io.adaptivecards.objectmodel.MarkDownParser;
import org.xml.sax.XMLReader;

public class RendererUtil {
    public static CharSequence handleSpecialText(String textWithFormattedDates) {
        MarkDownParser markDownParser = new MarkDownParser(textWithFormattedDates);
        String textString = markDownParser.TransformToHtml();
        textString = textString.replace("<li>", "<listItem>");
        Spanned htmlString = Build.VERSION.SDK_INT >= 24 ? Html.fromHtml((String)textString, (int)63, null, (Html.TagHandler)new UlTagHandler()) : Html.fromHtml((String)textString, null, (Html.TagHandler)new UlTagHandler());
        return RendererUtil.trimHtmlString(htmlString);
    }

    public static CharSequence trimHtmlString(Spanned htmlString) {
        int i;
        int numToRemoveFromEnd = 0;
        int numToRemoveFromStart = 0;
        for (i = htmlString.length() - 1; i >= 0 && htmlString.charAt(i) == '\n'; --i) {
            ++numToRemoveFromEnd;
        }
        for (i = 0; i <= htmlString.length() - 1 && htmlString.charAt(i) == '\n'; ++i) {
            ++numToRemoveFromStart;
        }
        if (numToRemoveFromStart + numToRemoveFromEnd >= htmlString.length()) {
            return htmlString;
        }
        return htmlString.subSequence(numToRemoveFromStart, htmlString.length() - numToRemoveFromEnd);
    }

    public static class UlTagHandler
    implements Html.TagHandler {
        private int tagNumber = 0;
        private boolean orderedList = false;

        public void handleTag(boolean opening, String tag, Editable output, XMLReader xmlReader) {
            if (tag.equals("ul") && !opening) {
                output.append((CharSequence)"\n");
            }
            if (tag.equals("listItem") && opening) {
                if (this.orderedList) {
                    output.append((CharSequence)"\n");
                    output.append((CharSequence)String.valueOf(this.tagNumber));
                    output.append((CharSequence)". ");
                    ++this.tagNumber;
                } else {
                    output.append((CharSequence)"\n\u2022 ");
                }
            }
            if (tag.equals("ol") && opening) {
                this.orderedList = true;
                this.tagNumber = 1;
            }
        }
    }
}

