/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentManager;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.text.style.TypefaceSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.adaptivecards.objectmodel.BaseActionElement;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.HeightType;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.Inline;
import io.adaptivecards.objectmodel.InlineElementType;
import io.adaptivecards.objectmodel.InlineVector;
import io.adaptivecards.objectmodel.Paragraph;
import io.adaptivecards.objectmodel.ParagraphVector;
import io.adaptivecards.objectmodel.RichTextBlock;
import io.adaptivecards.objectmodel.TextBlock;
import io.adaptivecards.objectmodel.TextRun;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.action.ActionElementRenderer;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.readonly.DateTimeParser;
import io.adaptivecards.renderer.readonly.RendererUtil;
import io.adaptivecards.renderer.readonly.TextRendererUtil;

public class RichTextBlockRenderer
extends BaseCardElementRenderer {
    private static RichTextBlockRenderer s_instance = null;

    public static RichTextBlockRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new RichTextBlockRenderer();
        }
        return s_instance;
    }

    private SpannableStringBuilder buildSpannableParagraph(RenderedAdaptiveCard renderedCard, InlineVector inlines, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) {
        SpannableStringBuilder paragraph = new SpannableStringBuilder();
        int lastStringLength = 0;
        for (int i = 0; i < inlines.size(); ++i) {
            Inline inline = inlines.get(i);
            if (inline.GetInlineType() == InlineElementType.TextRun) {
                TextRun textRun = null;
                if (inline instanceof TextRun) {
                    textRun = (TextRun)inline;
                } else {
                    textRun = TextRun.dynamic_cast(inline);
                    if (textRun == null) {
                        throw new InternalError("Unable to convert BaseCardElement to TextBlock object model.");
                    }
                }
                DateTimeParser parser = new DateTimeParser(textRun.GetLanguage());
                String textWithFormattedDates = parser.GenerateString(textRun.GetTextForDateParsing());
                CharSequence text = RendererUtil.handleSpecialText(textWithFormattedDates);
                paragraph.append(text);
                int spanStart = lastStringLength;
                int spanEnd = lastStringLength + text.length();
                int color = RichTextBlockRenderer.getColor(TextRendererUtil.getTextColor(textRun.GetTextColor(), hostConfig, textRun.GetIsSubtle(), renderArgs.getContainerStyle()));
                paragraph.setSpan((Object)new ForegroundColorSpan(color), spanStart, spanEnd, 17);
                paragraph.setSpan((Object)new StyleSpan(TextRendererUtil.getTextWeight(textRun.GetTextWeight())), spanStart, spanEnd, 17);
                long textSize = TextRendererUtil.getTextSize(textRun.GetFontStyle(), textRun.GetTextSize(), hostConfig);
                paragraph.setSpan((Object)new AbsoluteSizeSpan((int)textSize, true), spanStart, spanEnd, 17);
                String fontName = hostConfig.GetFontFamily(textRun.GetFontStyle());
                if (fontName.isEmpty()) {
                    fontName = "monospace";
                }
                paragraph.setSpan((Object)new TypefaceSpan(fontName), spanStart, spanEnd, 17);
                if (textRun.GetSelectAction() != null) {
                    paragraph.setSpan((Object)new ActionSpan(textRun.GetSelectAction(), renderedCard, cardActionHandler), spanStart, spanEnd, 17);
                }
            }
            lastStringLength = paragraph.length();
        }
        return paragraph;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) {
        int maxLines;
        RichTextBlock richTextBlock = null;
        if (baseCardElement instanceof TextBlock) {
            richTextBlock = (RichTextBlock)baseCardElement;
        } else {
            richTextBlock = RichTextBlock.dynamic_cast(baseCardElement);
            if (richTextBlock == null) {
                throw new InternalError("Unable to convert BaseCardElement to TextBlock object model.");
            }
        }
        TextView textView = new TextView(context);
        textView.setTag((Object)new TagContent(richTextBlock));
        textView.setEllipsize(TextUtils.TruncateAt.END);
        textView.setHorizontallyScrolling(false);
        RichTextBlockRenderer.setSpacingAndSeparator(context, viewGroup, richTextBlock.GetSpacing(), richTextBlock.GetSeparator(), hostConfig, true);
        if (!baseCardElement.GetIsVisible()) {
            textView.setVisibility(8);
        }
        if (richTextBlock.GetHeight() == HeightType.Stretch) {
            textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        } else {
            textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        }
        if (richTextBlock.GetMinHeight() != 0L) {
            textView.setMinimumHeight(Util.dpToPixels(context, (int)richTextBlock.GetMinHeight()));
        }
        if (!richTextBlock.GetWrap()) {
            textView.setMaxLines(1);
        }
        if ((maxLines = (int)richTextBlock.GetMaxLines()) > 0 && richTextBlock.GetWrap()) {
            textView.setMaxLines(maxLines);
        } else if (!richTextBlock.GetWrap()) {
            textView.setMaxLines(1);
        }
        textView.setGravity(TextRendererUtil.getTextAlignment(richTextBlock.GetHorizontalAlignment()));
        ParagraphVector paragraphs = richTextBlock.GetParagraphs();
        int paragraphCount = paragraphs.size();
        textView.setText((CharSequence)"");
        for (int i = 0; i < paragraphCount; ++i) {
            Paragraph p = paragraphs.get(i);
            InlineVector inlines = p.GetInlines();
            if (i != 0 && inlines.size() != 0) {
                textView.append((CharSequence)System.getProperty("line.separator"));
            }
            SpannableStringBuilder convertedString = this.buildSpannableParagraph(renderedCard, inlines, cardActionHandler, hostConfig, renderArgs);
            textView.append((CharSequence)convertedString);
        }
        textView.setMovementMethod(LinkMovementMethod.getInstance());
        textView.setClickable(true);
        viewGroup.addView((View)textView);
        return textView;
    }

    private class ActionSpan
    extends ClickableSpan {
        private ActionElementRenderer.ButtonOnClickListener m_actionListener;

        public ActionSpan(BaseActionElement action, RenderedAdaptiveCard renderedCard, ICardActionHandler cardActionHandler) {
            this.m_actionListener = new ActionElementRenderer.ButtonOnClickListener(renderedCard, action, cardActionHandler);
        }

        public void onClick(@NonNull View widget) {
            this.m_actionListener.onClick(widget);
        }
    }
}

