/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.graphics.Typeface;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.FontStyle;
import io.adaptivecards.objectmodel.ForegroundColor;
import io.adaptivecards.objectmodel.HorizontalAlignment;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.TextSize;
import io.adaptivecards.objectmodel.TextWeight;

public class TextRendererUtil {
    static int getTextAlignment(HorizontalAlignment textAlignment) {
        int alignment;
        if (textAlignment == HorizontalAlignment.Center) {
            alignment = 17;
        } else if (textAlignment == HorizontalAlignment.Left) {
            alignment = 3;
        } else if (textAlignment == HorizontalAlignment.Right) {
            alignment = 5;
        } else {
            throw new IllegalArgumentException("Invalid text alignment: " + textAlignment.toString());
        }
        return alignment;
    }

    static long getTextSize(FontStyle style2, TextSize textSize, HostConfig hostConfig) {
        return hostConfig.GetFontSize(style2, textSize);
    }

    static Typeface getTextFormat(HostConfig hostConfig, FontStyle style2) {
        String fontFamily = hostConfig.GetFontFamily(style2);
        Typeface typeface = fontFamily.isEmpty() && style2 == FontStyle.Monospace ? Typeface.MONOSPACE : Typeface.create((String)fontFamily, (int)0);
        return typeface;
    }

    static String getTextColor(ForegroundColor foregroundColor, HostConfig hostConfig, boolean isSubtle, ContainerStyle containerStyle) {
        return hostConfig.GetForegroundColor(containerStyle, foregroundColor, isSubtle);
    }

    static int getTextWeight(TextWeight textWeight) {
        int weight;
        if (textWeight == TextWeight.Default) {
            weight = 0;
        } else if (textWeight == TextWeight.Bolder) {
            weight = 1;
        } else if (textWeight == TextWeight.Lighter) {
            weight = 2;
        } else {
            throw new IllegalArgumentException("Invalid text weight: " + textWeight.toString());
        }
        return weight;
    }
}

