/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import io.adaptivecards.objectmodel.BackgroundImage;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.Column;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.VerticalContentAlignment;
import io.adaptivecards.renderer.AdaptiveFallbackException;
import io.adaptivecards.renderer.BackgroundImageLoaderAsync;
import io.adaptivecards.renderer.BaseActionElementRenderer;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.readonly.ContainerRenderer;
import io.adaptivecards.renderer.registration.CardRendererRegistration;
import java.util.Locale;

public class ColumnRenderer
extends BaseCardElementRenderer {
    private static ColumnRenderer s_instance = null;
    private final String g_columnSizeAuto = "auto";
    private final String g_columnSizeStretch = "stretch";

    protected ColumnRenderer() {
    }

    public static ColumnRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ColumnRenderer();
        }
        return s_instance;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) throws AdaptiveFallbackException {
        BackgroundImage backgroundImageProperties;
        Column column;
        if (baseCardElement instanceof Column) {
            column = (Column)baseCardElement;
        } else {
            column = Column.dynamic_cast(baseCardElement);
            if (column == null) {
                throw new InternalError("Unable to convert BaseCardElement to FactSet object model.");
            }
        }
        View separator = ColumnRenderer.setSpacingAndSeparator(context, viewGroup, column.GetSpacing(), column.GetSeparator(), hostConfig, false);
        LinearLayout returnedView = new LinearLayout(context);
        returnedView.setOrientation(1);
        returnedView.setTag((Object)new TagContent(column, separator, viewGroup));
        returnedView.setClipChildren(false);
        returnedView.setClipToPadding(false);
        ColumnRenderer.setVisibility(baseCardElement.GetIsVisible(), (View)returnedView);
        ColumnRenderer.setMinHeight(column.GetMinHeight(), (View)returnedView, context);
        LinearLayout verticalContentAlignmentLayout = new LinearLayout(context);
        verticalContentAlignmentLayout.setOrientation(0);
        verticalContentAlignmentLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        verticalContentAlignmentLayout.setClipChildren(false);
        verticalContentAlignmentLayout.setClipToPadding(false);
        VerticalContentAlignment contentAlignment = column.GetVerticalContentAlignment();
        switch (contentAlignment) {
            case Center: {
                verticalContentAlignmentLayout.setGravity(16);
                break;
            }
            case Bottom: {
                verticalContentAlignmentLayout.setGravity(80);
                break;
            }
            default: {
                verticalContentAlignmentLayout.setGravity(48);
            }
        }
        returnedView.addView((View)verticalContentAlignmentLayout);
        ContainerStyle containerStyle = renderArgs.getContainerStyle();
        ContainerStyle styleForThis = ContainerRenderer.GetLocalContainerStyle(column, containerStyle);
        RenderArgs columnRenderArgs = new RenderArgs(renderArgs);
        columnRenderArgs.setContainerStyle(styleForThis);
        if (!column.GetItems().isEmpty()) {
            CardRendererRegistration.getInstance().render(renderedCard, context, fragmentManager, (ViewGroup)verticalContentAlignmentLayout, column, column.GetItems(), cardActionHandler, hostConfig, columnRenderArgs);
        }
        if ((backgroundImageProperties = column.GetBackgroundImage()) != null && !backgroundImageProperties.GetUrl().isEmpty()) {
            BackgroundImageLoaderAsync loaderAsync = new BackgroundImageLoaderAsync(renderedCard, context, returnedView, hostConfig.GetImageBaseUrl(), context.getResources().getDisplayMetrics().widthPixels, backgroundImageProperties);
            loaderAsync.execute(new String[]{backgroundImageProperties.GetUrl()});
        }
        String columnSize = column.GetWidth().toLowerCase(Locale.getDefault());
        long pixelWidth = column.GetPixelWidth();
        if (pixelWidth != 0L) {
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1);
            layoutParams.width = Util.dpToPixels(context, pixelWidth);
            returnedView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        } else if (TextUtils.isEmpty((CharSequence)columnSize) || columnSize.equals("stretch")) {
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1, 1.0f);
            returnedView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        } else if (columnSize.equals("auto")) {
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -1);
            returnedView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        } else {
            try {
                float columnWeight = Float.parseFloat(columnSize);
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1);
                layoutParams.width = 0;
                layoutParams.weight = columnWeight;
                returnedView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
            catch (NumberFormatException numFormatExcep) {
                throw new IllegalArgumentException("Column Width (" + column.GetWidth() + ") is not a valid weight ('auto', 'stretch', <integer>).");
            }
        }
        ContainerRenderer.ApplyPadding(styleForThis, renderArgs.getContainerStyle(), returnedView, context, hostConfig);
        ContainerRenderer.ApplyBleed(column, returnedView, context, hostConfig);
        if (column.GetSelectAction() != null) {
            returnedView.setClickable(true);
            returnedView.setOnClickListener((View.OnClickListener)new BaseActionElementRenderer.SelectActionOnClickListener(renderedCard, column.GetSelectAction(), cardActionHandler));
        }
        viewGroup.addView((View)returnedView);
        return returnedView;
    }
}

