/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.input;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.ChoiceInput;
import io.adaptivecards.objectmodel.ChoiceInputVector;
import io.adaptivecards.objectmodel.ChoiceSetInput;
import io.adaptivecards.objectmodel.ChoiceSetStyle;
import io.adaptivecards.objectmodel.HeightType;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.inputhandler.CheckBoxSetInputHandler;
import io.adaptivecards.renderer.inputhandler.ComboBoxInputHandler;
import io.adaptivecards.renderer.inputhandler.RadioGroupInputHandler;
import io.adaptivecards.renderer.registration.CardRendererRegistration;
import java.util.Arrays;
import java.util.Vector;

public class ChoiceSetInputRenderer
extends BaseCardElementRenderer {
    private static ChoiceSetInputRenderer s_instance = null;

    protected ChoiceSetInputRenderer() {
    }

    public static ChoiceSetInputRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ChoiceSetInputRenderer();
        }
        return s_instance;
    }

    public View renderCheckBoxSet(RenderedAdaptiveCard renderedCard, Context context, ChoiceSetInput choiceSetInput, View separator, ViewGroup viewGroup) {
        LinearLayout layout2 = new LinearLayout(context);
        layout2.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        layout2.setOrientation(1);
        Vector<CheckBox> checkBoxList = new Vector<CheckBox>();
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        long size = choiceInputVector.size();
        String value = choiceSetInput.GetValue();
        Vector<String> defaults = new Vector<String>();
        defaults.addAll(Arrays.asList(value.split(",")));
        final CheckBoxSetInputHandler checkBoxSetInputHandler = new CheckBoxSetInputHandler(choiceSetInput, checkBoxList);
        checkBoxSetInputHandler.setView((View)layout2);
        layout2.setTag((Object)new TagContent(choiceSetInput, checkBoxSetInputHandler, separator, viewGroup));
        int i = 0;
        while ((long)i < size) {
            ChoiceInput choiceInput = choiceInputVector.get(i);
            CheckBox checkBox = new CheckBox(context);
            checkBox.setText((CharSequence)choiceInput.GetTitle());
            if (!choiceSetInput.GetWrap()) {
                checkBox.setLines(1);
                checkBox.setEllipsize(TextUtils.TruncateAt.END);
            }
            if (defaults.contains(choiceInput.GetValue())) {
                checkBox.setChecked(true);
            }
            checkBoxList.add(checkBox);
            checkBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    CardRendererRegistration.getInstance().notifyInputChange(checkBoxSetInputHandler.getId(), checkBoxSetInputHandler.getInput());
                }
            });
            layout2.addView((View)checkBox);
            ++i;
        }
        renderedCard.registerInputHandler(checkBoxSetInputHandler);
        return layout2;
    }

    public View renderRadioGroup(RenderedAdaptiveCard renderedCard, Context context, ChoiceSetInput choiceSetInput, View separator, ViewGroup viewGroup) {
        RadioGroup radioGroup = new RadioGroup(context);
        final RadioGroupInputHandler radioGroupInputHandler = new RadioGroupInputHandler(choiceSetInput);
        radioGroupInputHandler.setView((View)radioGroup);
        radioGroup.setTag((Object)new TagContent(choiceSetInput, radioGroupInputHandler, separator, viewGroup));
        radioGroup.setOrientation(1);
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        long size = choiceInputVector.size();
        String value = choiceSetInput.GetValue();
        int i = 0;
        while ((long)i < size) {
            ChoiceInput choiceInput = choiceInputVector.get(i);
            RadioButton radioButton = new RadioButton(context);
            radioButton.setId(i);
            if (!choiceSetInput.GetWrap()) {
                radioButton.setLines(1);
                radioButton.setEllipsize(TextUtils.TruncateAt.END);
            }
            radioButton.setText((CharSequence)choiceInput.GetTitle());
            if (choiceInput.GetValue().equals(value)) {
                radioButton.setChecked(true);
            }
            radioGroup.addView((View)radioButton);
            ++i;
        }
        renderedCard.registerInputHandler(radioGroupInputHandler);
        radioGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup group, int checkedId) {
                CardRendererRegistration.getInstance().notifyInputChange(radioGroupInputHandler.getId(), radioGroupInputHandler.getInput());
            }
        });
        return radioGroup;
    }

    public View renderComboBox(RenderedAdaptiveCard renderedCard, Context context, ChoiceSetInput choiceSetInput, View separator, ViewGroup viewGroup) {
        Vector<String> titleList = new Vector<String>();
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        long size = choiceInputVector.size();
        int selection = 0;
        String value = choiceSetInput.GetValue();
        int i = 0;
        while ((long)i < size) {
            ChoiceInput choiceInput = choiceInputVector.get(i);
            titleList.addElement(choiceInput.GetTitle());
            if (choiceInput.GetValue().equals(value)) {
                selection = i;
            }
            ++i;
        }
        final ComboBoxInputHandler comboBoxInputHandler = new ComboBoxInputHandler(choiceSetInput);
        Spinner spinner = new Spinner(context);
        comboBoxInputHandler.setView((View)spinner);
        spinner.setTag((Object)new TagContent(choiceSetInput, comboBoxInputHandler, separator, viewGroup));
        renderedCard.registerInputHandler(comboBoxInputHandler);
        class WrappedTextSpinnerAdapter
        extends ArrayAdapter<String> {
            WrappedTextSpinnerAdapter(Context context, int resource, Vector<String> items) {
                super(context, resource, items);
            }

            @NonNull
            public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
                View view = super.getView(position, convertView, parent);
                TextView txtView = (TextView)view.findViewById(16908308);
                txtView.setSingleLine(false);
                return view;
            }
        }
        ArrayAdapter spinnerArrayAdapter = choiceSetInput.GetWrap() ? new WrappedTextSpinnerAdapter(context, 17367048, titleList) : new ArrayAdapter(context, 17367048, titleList);
        spinnerArrayAdapter.setDropDownViewResource(0x1090009);
        spinner.setAdapter((SpinnerAdapter)spinnerArrayAdapter);
        spinner.setSelection(selection);
        spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                CardRendererRegistration.getInstance().notifyInputChange(comboBoxInputHandler.getId(), comboBoxInputHandler.getInput());
            }

            public void onNothingSelected(AdapterView<?> parent) {
                CardRendererRegistration.getInstance().notifyInputChange(comboBoxInputHandler.getId(), comboBoxInputHandler.getInput());
            }
        });
        return spinner;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) {
        if (!hostConfig.GetSupportsInteractivity()) {
            renderedCard.addWarning(new AdaptiveWarning(3, "Input.ChoiceSet is not allowed"));
            return null;
        }
        ChoiceSetInput choiceSetInput = null;
        if (baseCardElement instanceof ChoiceSetInput) {
            choiceSetInput = (ChoiceSetInput)baseCardElement;
        } else {
            choiceSetInput = ChoiceSetInput.dynamic_cast(baseCardElement);
            if (choiceSetInput == null) {
                throw new InternalError("Unable to convert BaseCardElement to ChoiceSetInput object model.");
            }
        }
        View separator = ChoiceSetInputRenderer.setSpacingAndSeparator(context, viewGroup, choiceSetInput.GetSpacing(), choiceSetInput.GetSeparator(), hostConfig, true);
        View view = null;
        if (choiceSetInput.GetIsMultiSelect()) {
            view = this.renderCheckBoxSet(renderedCard, context, choiceSetInput, separator, viewGroup);
        } else if (choiceSetInput.GetChoiceSetStyle() == ChoiceSetStyle.Expanded) {
            view = this.renderRadioGroup(renderedCard, context, choiceSetInput, separator, viewGroup);
        } else if (choiceSetInput.GetChoiceSetStyle() == ChoiceSetStyle.Compact) {
            view = this.renderComboBox(renderedCard, context, choiceSetInput, separator, viewGroup);
        } else {
            throw new IllegalArgumentException("ChoiceSet Input, " + choiceSetInput.GetId() + ", contains invalid style, " + choiceSetInput.GetChoiceSetStyle().toString() + ".");
        }
        if (choiceSetInput.GetHeight() == HeightType.Stretch) {
            LinearLayout containerLayout = new LinearLayout(context);
            containerLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -1, 1.0f));
            TagContent tagContent = (TagContent)view.getTag();
            tagContent.SetStretchContainer((View)containerLayout);
            containerLayout.addView(view);
            viewGroup.addView((View)containerLayout);
        } else {
            viewGroup.addView(view);
        }
        ChoiceSetInputRenderer.setVisibility(choiceSetInput.GetIsVisible(), view);
        return view;
    }
}

