/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.inputhandler;

import android.widget.RadioGroup;
import io.adaptivecards.objectmodel.BaseInputElement;
import io.adaptivecards.objectmodel.ChoiceInput;
import io.adaptivecards.objectmodel.ChoiceInputVector;
import io.adaptivecards.objectmodel.ChoiceSetInput;
import io.adaptivecards.renderer.inputhandler.BaseInputHandler;

public class RadioGroupInputHandler
extends BaseInputHandler {
    public RadioGroupInputHandler(BaseInputElement baseInputElement) {
        super(baseInputElement);
    }

    protected RadioGroup getRadioGroup() {
        return (RadioGroup)this.m_view;
    }

    @Override
    public String getInput() {
        ChoiceSetInput choiceSetInput = (ChoiceSetInput)this.m_baseInputElement;
        int index = this.getRadioGroup().getCheckedRadioButtonId();
        if (index >= 0) {
            return choiceSetInput.GetChoices().get(index).GetValue();
        }
        return "";
    }

    @Override
    public void setInput(String choice) {
        ChoiceSetInput choiceSetInput = (ChoiceSetInput)this.m_baseInputElement;
        RadioGroup radioGroup = this.getRadioGroup();
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        if (!choice.isEmpty()) {
            for (int i = 0; i < choiceInputVector.size(); ++i) {
                ChoiceInput choiceInput = choiceInputVector.get(i);
                if (!choice.equals(choiceInput.GetValue())) continue;
                radioGroup.check(i);
                break;
            }
        } else {
            radioGroup.check(-1);
        }
    }
}

