/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.graphics.Color;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import io.adaptivecards.objectmodel.BackgroundImage;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.CollectionTypeElement;
import io.adaptivecards.objectmodel.Container;
import io.adaptivecards.objectmodel.ContainerBleedDirection;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.HeightType;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.VerticalContentAlignment;
import io.adaptivecards.renderer.AdaptiveFallbackException;
import io.adaptivecards.renderer.BackgroundImageLoaderAsync;
import io.adaptivecards.renderer.BaseActionElementRenderer;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.registration.CardRendererRegistration;

public class ContainerRenderer
extends BaseCardElementRenderer {
    private static ContainerRenderer s_instance = null;

    protected ContainerRenderer() {
    }

    public static ContainerRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ContainerRenderer();
        }
        return s_instance;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) throws AdaptiveFallbackException {
        BackgroundImage backgroundImageProperties;
        Container container = null;
        if (baseCardElement instanceof Container) {
            container = (Container)baseCardElement;
        } else {
            container = Container.dynamic_cast(baseCardElement);
            if (container == null) {
                throw new InternalError("Unable to convert BaseCardElement to Container object model.");
            }
        }
        View separator = ContainerRenderer.setSpacingAndSeparator(context, viewGroup, container.GetSpacing(), container.GetSeparator(), hostConfig, true);
        LinearLayout containerView = new LinearLayout(context);
        containerView.setTag((Object)new TagContent(container, separator, viewGroup));
        containerView.setOrientation(1);
        ContainerRenderer.setVisibility(container.GetIsVisible(), (View)containerView);
        ContainerRenderer.setMinHeight(container.GetMinHeight(), (View)containerView, context);
        containerView.setClipChildren(false);
        containerView.setClipToPadding(false);
        if (container.GetHeight() == HeightType.Stretch) {
            containerView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        } else {
            containerView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        }
        VerticalContentAlignment contentAlignment = container.GetVerticalContentAlignment();
        switch (contentAlignment) {
            case Center: {
                containerView.setGravity(16);
                break;
            }
            case Bottom: {
                containerView.setGravity(80);
                break;
            }
            default: {
                containerView.setGravity(48);
            }
        }
        ContainerStyle containerStyle = renderArgs.getContainerStyle();
        ContainerStyle styleForThis = ContainerRenderer.GetLocalContainerStyle(container, containerStyle);
        ContainerRenderer.ApplyPadding(styleForThis, containerStyle, containerView, context, hostConfig);
        ContainerRenderer.ApplyBleed(container, containerView, context, hostConfig);
        RenderArgs containerRenderArgs = new RenderArgs(renderArgs);
        containerRenderArgs.setContainerStyle(styleForThis);
        if (!container.GetItems().isEmpty()) {
            try {
                CardRendererRegistration.getInstance().render(renderedCard, context, fragmentManager, (ViewGroup)containerView, container, container.GetItems(), cardActionHandler, hostConfig, containerRenderArgs);
            }
            catch (AdaptiveFallbackException e) {
                viewGroup.removeView(separator);
                throw e;
            }
        }
        if ((backgroundImageProperties = container.GetBackgroundImage()) != null && !backgroundImageProperties.GetUrl().isEmpty()) {
            BackgroundImageLoaderAsync loaderAsync = new BackgroundImageLoaderAsync(renderedCard, context, containerView, hostConfig.GetImageBaseUrl(), context.getResources().getDisplayMetrics().widthPixels, backgroundImageProperties);
            loaderAsync.execute(new String[]{backgroundImageProperties.GetUrl()});
        }
        if (container.GetSelectAction() != null) {
            containerView.setClickable(true);
            containerView.setOnClickListener((View.OnClickListener)new BaseActionElementRenderer.SelectActionOnClickListener(renderedCard, container.GetSelectAction(), cardActionHandler));
        }
        viewGroup.addView((View)containerView);
        return containerView;
    }

    public static void ApplyBleed(CollectionTypeElement collectionElement, LinearLayout collectionElementView, Context context, HostConfig hostConfig) {
        if (collectionElement.GetBleed() && collectionElement.GetCanBleed()) {
            int padding = Util.dpToPixels(context, hostConfig.GetSpacing().getPaddingSpacing());
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)collectionElementView.getLayoutParams();
            int marginLeft = layoutParams.leftMargin;
            int marginRight = layoutParams.rightMargin;
            int marginTop = layoutParams.topMargin;
            int marginBottom = layoutParams.bottomMargin;
            ContainerBleedDirection bleedDirection = collectionElement.GetBleedDirection();
            if ((bleedDirection.swigValue() & ContainerBleedDirection.BleedLeft.swigValue()) != ContainerBleedDirection.BleedRestricted.swigValue()) {
                marginLeft = -padding;
            }
            if ((bleedDirection.swigValue() & ContainerBleedDirection.BleedRight.swigValue()) != ContainerBleedDirection.BleedRestricted.swigValue()) {
                marginRight = -padding;
            }
            if ((bleedDirection.swigValue() & ContainerBleedDirection.BleedUp.swigValue()) != ContainerBleedDirection.BleedRestricted.swigValue()) {
                marginTop = -padding;
            }
            if ((bleedDirection.swigValue() & ContainerBleedDirection.BleedDown.swigValue()) != ContainerBleedDirection.BleedRestricted.swigValue()) {
                marginBottom = -padding;
            }
            layoutParams.setMargins(marginLeft, marginTop, marginRight, marginBottom);
            collectionElementView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    public static void ApplyPadding(ContainerStyle elementContainerStyle, ContainerStyle parentContainerStyle, LinearLayout collectionElementView, Context context, HostConfig hostConfig) {
        if (elementContainerStyle != parentContainerStyle) {
            int padding = Util.dpToPixels(context, hostConfig.GetSpacing().getPaddingSpacing());
            collectionElementView.setPadding(padding, padding, padding, padding);
            String color = hostConfig.GetBackgroundColor(elementContainerStyle);
            collectionElementView.setBackgroundColor(Color.parseColor((String)color));
        }
    }

    public static ContainerStyle GetLocalContainerStyle(CollectionTypeElement collectionElement, ContainerStyle parentContainerStyle) {
        return collectionElement.GetStyle().swigValue() == ContainerStyle.None.swigValue() ? parentContainerStyle : collectionElement.GetStyle();
    }
}

