/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Shader;
import android.os.AsyncTask;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.HeightType;
import io.adaptivecards.objectmodel.HorizontalAlignment;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.Image;
import io.adaptivecards.objectmodel.ImageSize;
import io.adaptivecards.objectmodel.ImageSizesConfig;
import io.adaptivecards.objectmodel.ImageStyle;
import io.adaptivecards.renderer.BaseActionElementRenderer;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.IOnlineImageLoader;
import io.adaptivecards.renderer.InnerImageLoaderAsync;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.layout.HorizontalFlowLayout;
import io.adaptivecards.renderer.registration.CardRendererRegistration;

public class ImageRenderer
extends BaseCardElementRenderer {
    private static ImageRenderer s_instance = null;

    protected ImageRenderer() {
    }

    public static ImageRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ImageRenderer();
        }
        return s_instance;
    }

    private static int getImageSizePixels(Context context, ImageSize imageSize, ImageSizesConfig imageSizesConfig) {
        int imageSizeLimit = context.getResources().getDisplayMetrics().widthPixels;
        if (imageSize == ImageSize.Small) {
            imageSizeLimit = Util.dpToPixels(context, imageSizesConfig.getSmallSize());
        } else if (imageSize == ImageSize.Medium) {
            imageSizeLimit = Util.dpToPixels(context, imageSizesConfig.getMediumSize());
        } else if (imageSize == ImageSize.Large) {
            imageSizeLimit = Util.dpToPixels(context, imageSizesConfig.getLargeSize());
        }
        return imageSizeLimit;
    }

    private static void setImageSize(Context context, ImageView imageView, Image image, HostConfig hostConfig, boolean isInImageSet) {
        LinearLayout.LayoutParams params;
        long explicitWidth = image.GetPixelWidth();
        long explicitHeight = image.GetPixelHeight();
        ImageSize imageSize = image.GetImageSize();
        imageView.setAdjustViewBounds(true);
        imageView.setScaleType(ImageView.ScaleType.FIT_START);
        int viewWidth = -2;
        int viewHeight = -2;
        if (explicitWidth != 0L || explicitHeight != 0L) {
            if (explicitWidth != 0L && explicitHeight != 0L) {
                imageView.setScaleType(ImageView.ScaleType.FIT_XY);
            }
            if (explicitWidth != 0L) {
                viewWidth = Util.dpToPixels(context, explicitWidth);
            }
            if (explicitHeight != 0L) {
                viewHeight = Util.dpToPixels(context, explicitHeight);
            }
        } else if (imageSize == ImageSize.Stretch) {
            viewWidth = -1;
        } else if (imageSize == ImageSize.Small || imageSize == ImageSize.Medium || imageSize == ImageSize.Large) {
            viewWidth = ImageRenderer.getImageSizePixels(context, imageSize, hostConfig.GetImageSizes());
        } else if (imageSize != ImageSize.Auto && imageSize != ImageSize.None) {
            throw new IllegalArgumentException("Unknown image size: " + imageSize.toString());
        }
        if ((params = (LinearLayout.LayoutParams)imageView.getLayoutParams()) == null) {
            params = new LinearLayout.LayoutParams(viewWidth, viewHeight);
        } else {
            params.width = viewWidth;
            params.height = viewHeight;
        }
        imageView.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) {
        Image image;
        if (baseCardElement instanceof Image) {
            image = (Image)baseCardElement;
        } else {
            image = Image.dynamic_cast(baseCardElement);
            if (image == null) {
                throw new InternalError("Unable to convert BaseCardElement to Image object model.");
            }
        }
        boolean isInImageSet = viewGroup instanceof HorizontalFlowLayout;
        View separator = ImageRenderer.setSpacingAndSeparator(context, viewGroup, image.GetSpacing(), image.GetSeparator(), hostConfig, !isInImageSet, isInImageSet);
        ImageView imageView = new ImageView(context);
        imageView.setTag((Object)new TagContent(image, separator, viewGroup));
        ImageRenderer.setVisibility(baseCardElement.GetIsVisible(), (View)imageView);
        String imageBackgroundColor = image.GetBackgroundColor();
        int backgroundColor = 0;
        if (!TextUtils.isEmpty((CharSequence)imageBackgroundColor)) {
            if (imageBackgroundColor.length() == 9 && imageBackgroundColor.charAt(0) == '#') {
                try {
                    backgroundColor = Color.parseColor((String)imageBackgroundColor);
                }
                catch (IllegalArgumentException e) {
                    backgroundColor = 0;
                }
            } else {
                backgroundColor = 0;
            }
        }
        if (image.GetImageStyle() != ImageStyle.Person) {
            imageView.setBackgroundColor(backgroundColor);
        }
        int imageSizeLimit = ImageRenderer.getImageSizePixels(context, image.GetImageSize(), hostConfig.GetImageSizes());
        ImageRendererImageLoaderAsync imageLoaderAsync = new ImageRendererImageLoaderAsync(renderedCard, imageView, hostConfig.GetImageBaseUrl(), image.GetImageStyle(), backgroundColor, imageSizeLimit);
        IOnlineImageLoader onlineImageLoader = CardRendererRegistration.getInstance().getOnlineImageLoader();
        if (onlineImageLoader != null) {
            imageLoaderAsync.registerCustomOnlineImageLoader(onlineImageLoader);
        }
        imageLoaderAsync.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[]{image.GetUrl()});
        LinearLayout.LayoutParams layoutParams = image.GetImageSize() == ImageSize.Stretch ? (image.GetHeight() == HeightType.Stretch ? new LinearLayout.LayoutParams(-1, -1, 1.0f) : new LinearLayout.LayoutParams(-1, -2)) : (image.GetHeight() == HeightType.Stretch ? new LinearLayout.LayoutParams(-2, -1, 1.0f) : new LinearLayout.LayoutParams(-2, -2));
        HorizontalAlignment horizontalAlignment = image.GetHorizontalAlignment();
        if (horizontalAlignment == HorizontalAlignment.Right) {
            layoutParams.gravity = 5;
        } else if (horizontalAlignment == HorizontalAlignment.Center) {
            layoutParams.gravity = 1;
        }
        if (image.GetSelectAction() != null) {
            imageView.setClickable(true);
            imageView.setOnClickListener((View.OnClickListener)new BaseActionElementRenderer.SelectActionOnClickListener(renderedCard, image.GetSelectAction(), cardActionHandler));
        }
        imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        ImageRenderer.setImageSize(context, imageView, image, hostConfig, isInImageSet);
        viewGroup.addView((View)imageView);
        return imageView;
    }

    private class ImageRendererImageLoaderAsync
    extends InnerImageLoaderAsync {
        private ImageStyle m_imageStyle;
        private int m_backgroundColor;

        ImageRendererImageLoaderAsync(RenderedAdaptiveCard renderedCard, ImageView imageView, String imageBaseUrl, ImageStyle imageStyle, int backgroundColor) {
            this(renderedCard, imageView, imageBaseUrl, imageStyle, backgroundColor, -1);
        }

        ImageRendererImageLoaderAsync(RenderedAdaptiveCard renderedCard, ImageView imageView, String imageBaseUrl, ImageStyle imageStyle, int backgroundColor, int maxWidth) {
            super(renderedCard, (View)imageView, imageBaseUrl, maxWidth);
            this.m_imageStyle = imageStyle;
            this.m_backgroundColor = backgroundColor;
        }

        @Override
        public Bitmap styleBitmap(Bitmap bitmap) {
            if (bitmap != null && this.m_imageStyle == ImageStyle.Person) {
                Bitmap circleBitmap = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                BitmapShader shader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
                Paint paint = new Paint();
                paint.setShader((Shader)shader);
                Paint backgroundColorPaint = new Paint();
                backgroundColorPaint.setColor(this.m_backgroundColor);
                Canvas c = new Canvas(circleBitmap);
                c.drawCircle((float)(bitmap.getWidth() / 2), (float)(bitmap.getHeight() / 2), (float)(bitmap.getWidth() / 2), backgroundColorPaint);
                c.drawCircle((float)(bitmap.getWidth() / 2), (float)(bitmap.getHeight() / 2), (float)(bitmap.getWidth() / 2), paint);
                bitmap = circleBitmap;
            }
            return bitmap;
        }

        @Override
        protected void renderBitmap(Bitmap bitmap) {
            ImageView view = (ImageView)this.m_view;
            view.setImageBitmap(bitmap);
        }
    }
}

