/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.widget.LinearLayout;
import io.adaptivecards.objectmodel.BackgroundImage;
import io.adaptivecards.renderer.GenericImageLoaderAsync;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.http.HttpRequestResult;

public class BackgroundImageLoaderAsync
extends GenericImageLoaderAsync {
    private Context m_context;
    private LinearLayout m_layout;
    private BackgroundImage m_backgroundImageProperties;

    public BackgroundImageLoaderAsync(RenderedAdaptiveCard renderedCard, Context context, LinearLayout layout, String imageBaseUrl, int maxWidth, BackgroundImage backgroundImageProperties) {
        super(renderedCard, imageBaseUrl, maxWidth);
        this.m_context = context;
        this.m_layout = layout;
        this.m_backgroundImageProperties = backgroundImageProperties;
    }

    protected HttpRequestResult<Bitmap> doInBackground(String ... args) {
        if (args.length == 0) {
            return null;
        }
        return this.loadImage(args[0], this.m_context);
    }

    @Override
    void onSuccessfulPostExecute(Bitmap bitmap) {
        BackgroundImageDrawable background = new BackgroundImageDrawable(this.m_context.getResources(), bitmap, this.m_backgroundImageProperties);
        this.m_layout.setBackground((Drawable)background);
    }

    private class BackgroundImageDrawable
    extends BitmapDrawable {
        private Bitmap m_bitmap;
        private BackgroundImage m_backgroundImageProperties;

        public BackgroundImageDrawable(Resources resources, Bitmap bitmap, BackgroundImage backgroundImageProperties) {
            super(resources, Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888));
            this.m_bitmap = bitmap;
            this.m_backgroundImageProperties = backgroundImageProperties;
        }

        public void draw(Canvas canvas) {
            switch (this.m_backgroundImageProperties.GetFillMode()) {
                case Repeat: {
                    this.tileHorizontallyAndVertically(canvas);
                    break;
                }
                case RepeatVertically: {
                    this.tileVertically(canvas);
                    break;
                }
                case RepeatHorizontally: {
                    this.tileHorizontally(canvas);
                    break;
                }
                default: {
                    this.resizeBitmapForCover(canvas);
                }
            }
        }

        private double getScaleFactorForCover(Canvas containerCanvas, Bitmap originalSizeBitmap) {
            double xScaleFactor = (double)containerCanvas.getWidth() / (double)originalSizeBitmap.getWidth();
            double yScaleFactor = (double)containerCanvas.getHeight() / (double)originalSizeBitmap.getHeight();
            return Math.max(xScaleFactor, yScaleFactor);
        }

        private void resizeBitmapForCover(Canvas canvas) {
            Bitmap bitmap = this.m_bitmap;
            double originalWidth = bitmap.getWidth();
            double originalHeight = bitmap.getHeight();
            double scale = this.getScaleFactorForCover(canvas, bitmap);
            int scaledWidth = (int)(scale * originalWidth);
            int scaledHeight = (int)(scale * originalHeight);
            Bitmap background = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas backgroundCanvas = new Canvas(background);
            Matrix transformation = new Matrix();
            transformation.preScale((float)scale, (float)scale);
            Paint scaledImagePaint = new Paint();
            scaledImagePaint.setFilterBitmap(true);
            backgroundCanvas.drawBitmap(bitmap, transformation, scaledImagePaint);
            int canvasWidth = canvas.getWidth();
            int canvasHeight = canvas.getHeight();
            int origX = 0;
            int origY = 0;
            switch (this.m_backgroundImageProperties.GetHorizontalAlignment()) {
                case Center: {
                    origX = (scaledWidth - canvasWidth) / 2;
                    break;
                }
                case Right: {
                    origX = scaledWidth - canvasWidth;
                }
            }
            switch (this.m_backgroundImageProperties.GetVerticalAlignment()) {
                case Center: {
                    origY = (scaledHeight - canvasHeight) / 2;
                    break;
                }
                case Bottom: {
                    origY = scaledHeight - canvasHeight;
                }
            }
            canvas.drawBitmap(background, new Rect(origX, origY, origX + canvasWidth, origY + canvasHeight), new Rect(0, 0, canvasWidth, canvasHeight), scaledImagePaint);
        }

        private void tileHorizontally(Canvas canvas) {
            float verticalOffset;
            Bitmap bitmap = this.m_bitmap;
            switch (this.m_backgroundImageProperties.GetVerticalAlignment()) {
                case Bottom: {
                    verticalOffset = canvas.getHeight() - bitmap.getHeight();
                    break;
                }
                case Center: {
                    verticalOffset = (float)(canvas.getHeight() - bitmap.getHeight()) / 2.0f;
                    break;
                }
                default: {
                    verticalOffset = 0.0f;
                }
            }
            int imageWidth = bitmap.getWidth();
            int canvasWidth = canvas.getWidth();
            for (int x = 0; x < canvasWidth; x += imageWidth) {
                int remainingWidth = canvasWidth - x;
                if (imageWidth <= remainingWidth) {
                    canvas.drawBitmap(bitmap, (float)x, verticalOffset, this.getPaint());
                    continue;
                }
                int imageHeight = bitmap.getHeight();
                canvas.drawBitmap(bitmap, new Rect(0, 0, remainingWidth, imageHeight), new Rect(x, (int)verticalOffset, canvasWidth, (int)verticalOffset + imageHeight), this.getPaint());
            }
        }

        private void tileVertically(Canvas canvas) {
            float horizontalOffset;
            Bitmap bitmap = this.m_bitmap;
            switch (this.m_backgroundImageProperties.GetHorizontalAlignment()) {
                case Right: {
                    horizontalOffset = canvas.getWidth() - bitmap.getWidth();
                    break;
                }
                case Center: {
                    horizontalOffset = (float)(canvas.getWidth() - bitmap.getWidth()) / 2.0f;
                    break;
                }
                default: {
                    horizontalOffset = 0.0f;
                }
            }
            int imageHeight = bitmap.getHeight();
            int canvasHeight = canvas.getHeight();
            for (int y = 0; y < canvasHeight; y += imageHeight) {
                int remainingHeight = canvasHeight - y;
                if (imageHeight <= remainingHeight) {
                    canvas.drawBitmap(bitmap, horizontalOffset, (float)y, this.getPaint());
                    continue;
                }
                int imageWidth = bitmap.getWidth();
                canvas.drawBitmap(bitmap, new Rect(0, 0, imageWidth, remainingHeight), new Rect((int)horizontalOffset, y, (int)horizontalOffset + imageWidth, canvasHeight), this.getPaint());
            }
        }

        private void tileHorizontallyAndVertically(Canvas canvas) {
            Bitmap bitmap = this.m_bitmap;
            int imageHeight = bitmap.getHeight();
            int imageWidth = bitmap.getWidth();
            int canvasHeight = canvas.getHeight();
            int canvasWidth = canvas.getWidth();
            for (int y = 0; y < canvasHeight; y += imageHeight) {
                int remainingHeight = canvasHeight - y;
                for (int x = 0; x < canvasWidth; x += imageWidth) {
                    int remainingWidth = canvasWidth - x;
                    if (imageWidth <= remainingWidth && imageHeight <= remainingHeight) {
                        canvas.drawBitmap(bitmap, (float)x, (float)y, this.getPaint());
                        continue;
                    }
                    int drawableWidth = Math.min(remainingWidth, imageWidth);
                    int drawableHeight = Math.min(remainingHeight, imageHeight);
                    canvas.drawBitmap(bitmap, new Rect(0, 0, drawableWidth, drawableHeight), new Rect(x, y, x + drawableWidth, y + drawableHeight), this.getPaint());
                }
            }
        }
    }
}

