/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.CardElementType;
import io.adaptivecards.objectmodel.Column;
import io.adaptivecards.objectmodel.ColumnSet;
import io.adaptivecards.objectmodel.ColumnVector;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.FeatureRegistration;
import io.adaptivecards.objectmodel.HeightType;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.renderer.AdaptiveFallbackException;
import io.adaptivecards.renderer.BaseActionElementRenderer;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.IBaseCardElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.readonly.ContainerRenderer;
import io.adaptivecards.renderer.registration.CardRendererRegistration;

public class ColumnSetRenderer
extends BaseCardElementRenderer {
    private static ColumnSetRenderer s_instance = null;

    protected ColumnSetRenderer() {
    }

    public static ColumnSetRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ColumnSetRenderer();
        }
        return s_instance;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) throws AdaptiveFallbackException {
        ColumnSet columnSet = null;
        if (baseCardElement instanceof ColumnSet) {
            columnSet = (ColumnSet)baseCardElement;
        } else {
            columnSet = ColumnSet.dynamic_cast(baseCardElement);
            if (columnSet == null) {
                throw new InternalError("Unable to convert BaseCardElement to ColumnSet object model.");
            }
        }
        IBaseCardElementRenderer columnRenderer = CardRendererRegistration.getInstance().getRenderer(CardElementType.Column.toString());
        if (columnRenderer == null) {
            throw new UnknownError(CardElementType.Column.toString() + " is not a registered renderer.");
        }
        View separator = ColumnSetRenderer.setSpacingAndSeparator(context, viewGroup, columnSet.GetSpacing(), columnSet.GetSeparator(), hostConfig, true);
        ColumnVector columnVector = columnSet.GetColumns();
        long columnVectorSize = columnVector.size();
        LinearLayout layout = new LinearLayout(context);
        layout.setClipChildren(false);
        layout.setClipToPadding(false);
        ColumnSetRenderer.setMinHeight(columnSet.GetMinHeight(), (View)layout, context);
        ContainerStyle parentContainerStyle = renderArgs.getContainerStyle();
        ContainerStyle styleForThis = ContainerRenderer.GetLocalContainerStyle(columnSet, parentContainerStyle);
        int i = 0;
        while ((long)i < columnVectorSize) {
            Column column = columnVector.get(i);
            RenderArgs columnRenderArgs = new RenderArgs(renderArgs);
            columnRenderArgs.setContainerStyle(styleForThis);
            FeatureRegistration featureRegistration = CardRendererRegistration.getInstance().getFeatureRegistration();
            CardRendererRegistration.getInstance().renderElementAndPerformFallback(renderedCard, context, fragmentManager, column, (ViewGroup)layout, cardActionHandler, hostConfig, columnRenderArgs, featureRegistration);
            ++i;
        }
        if (columnSet.GetSelectAction() != null) {
            layout.setClickable(true);
            layout.setOnClickListener((View.OnClickListener)new BaseActionElementRenderer.SelectActionOnClickListener(renderedCard, columnSet.GetSelectAction(), cardActionHandler));
        }
        TagContent tagContent = new TagContent(columnSet, separator, viewGroup);
        if (columnSet.GetHeight() == HeightType.Stretch) {
            LinearLayout stretchLayout = new LinearLayout(context);
            stretchLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
            stretchLayout.setOrientation(1);
            layout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
            tagContent.SetStretchContainer((View)stretchLayout);
            stretchLayout.addView((View)layout);
            viewGroup.addView((View)stretchLayout);
        } else {
            layout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            viewGroup.addView((View)layout);
        }
        layout.setTag((Object)tagContent);
        ColumnSetRenderer.setVisibility(baseCardElement.GetIsVisible(), (View)layout);
        ContainerRenderer.ApplyPadding(styleForThis, parentContainerStyle, layout, context, hostConfig);
        ContainerRenderer.ApplyBleed(columnSet, layout, context, hostConfig);
        return layout;
    }
}

