/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.registration;

import android.content.Context;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import io.adaptivecards.objectmodel.ActionType;
import io.adaptivecards.objectmodel.AdaptiveCard;
import io.adaptivecards.objectmodel.AdaptiveCardObjectModel;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.BaseCardElementVector;
import io.adaptivecards.objectmodel.BaseElement;
import io.adaptivecards.objectmodel.CardElementType;
import io.adaptivecards.objectmodel.Column;
import io.adaptivecards.objectmodel.Container;
import io.adaptivecards.objectmodel.FallbackType;
import io.adaptivecards.objectmodel.FeatureRegistration;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.VerticalContentAlignment;
import io.adaptivecards.renderer.ActionLayoutRenderer;
import io.adaptivecards.renderer.AdaptiveFallbackException;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.IActionLayoutRenderer;
import io.adaptivecards.renderer.IBaseActionElementRenderer;
import io.adaptivecards.renderer.IBaseCardElementRenderer;
import io.adaptivecards.renderer.IOnlineImageLoader;
import io.adaptivecards.renderer.IOnlineMediaLoader;
import io.adaptivecards.renderer.IResourceResolver;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.action.ActionElementRenderer;
import io.adaptivecards.renderer.action.ActionSetRenderer;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.input.ChoiceSetInputRenderer;
import io.adaptivecards.renderer.input.DateInputRenderer;
import io.adaptivecards.renderer.input.NumberInputRenderer;
import io.adaptivecards.renderer.input.TextInputRenderer;
import io.adaptivecards.renderer.input.TimeInputRenderer;
import io.adaptivecards.renderer.input.ToggleInputRenderer;
import io.adaptivecards.renderer.inputhandler.IInputWatcher;
import io.adaptivecards.renderer.readonly.ColumnRenderer;
import io.adaptivecards.renderer.readonly.ColumnSetRenderer;
import io.adaptivecards.renderer.readonly.ContainerRenderer;
import io.adaptivecards.renderer.readonly.FactSetRenderer;
import io.adaptivecards.renderer.readonly.ImageRenderer;
import io.adaptivecards.renderer.readonly.ImageSetRenderer;
import io.adaptivecards.renderer.readonly.MediaRenderer;
import io.adaptivecards.renderer.readonly.RichTextBlockRenderer;
import io.adaptivecards.renderer.readonly.TextBlockRenderer;
import java.util.HashMap;

public class CardRendererRegistration {
    private static CardRendererRegistration s_instance = null;
    private IInputWatcher m_InputWatcher = null;
    private HashMap<String, IBaseCardElementRenderer> m_typeToRendererMap = new HashMap();
    private HashMap<String, IBaseActionElementRenderer> m_typeToRenderActionMap = new HashMap();
    private IActionLayoutRenderer m_actionLayoutRenderer = null;
    private IOnlineImageLoader m_onlineImageLoader = null;
    private HashMap<String, IResourceResolver> m_resourceResolvers = new HashMap();
    private IOnlineMediaLoader m_onlineMediaLoader = null;
    private FeatureRegistration m_featureRegistration = null;

    private CardRendererRegistration() {
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.Column), ColumnRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.ColumnSet), ColumnSetRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.Container), ContainerRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.FactSet), FactSetRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.Image), ImageRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.ImageSet), ImageSetRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.Media), MediaRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.RichTextBlock), RichTextBlockRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.TextBlock), TextBlockRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.ActionSet), ActionSetRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.TextInput), TextInputRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.NumberInput), NumberInputRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.DateInput), DateInputRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.TimeInput), TimeInputRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.ToggleInput), ToggleInputRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.ChoiceSetInput), ChoiceSetInputRenderer.getInstance());
        this.registerActionRenderer(AdaptiveCardObjectModel.ActionTypeToString(ActionType.Submit), ActionElementRenderer.getInstance());
        this.registerActionRenderer(AdaptiveCardObjectModel.ActionTypeToString(ActionType.ShowCard), ActionElementRenderer.getInstance());
        this.registerActionRenderer(AdaptiveCardObjectModel.ActionTypeToString(ActionType.OpenUrl), ActionElementRenderer.getInstance());
        this.registerActionRenderer(AdaptiveCardObjectModel.ActionTypeToString(ActionType.ToggleVisibility), ActionElementRenderer.getInstance());
        this.m_actionLayoutRenderer = ActionLayoutRenderer.getInstance();
    }

    public static CardRendererRegistration getInstance() {
        if (s_instance == null) {
            s_instance = new CardRendererRegistration();
        }
        return s_instance;
    }

    public void registerRenderer(String cardElementType, IBaseCardElementRenderer renderer) {
        if (TextUtils.isEmpty((CharSequence)cardElementType)) {
            throw new IllegalArgumentException("cardElementType is null");
        }
        if (renderer == null) {
            throw new IllegalArgumentException("renderer is null");
        }
        this.m_typeToRendererMap.put(cardElementType, renderer);
    }

    public IBaseCardElementRenderer getRenderer(String cardElementType) {
        return this.m_typeToRendererMap.get(cardElementType);
    }

    public void setInputWatcher(IInputWatcher inputWatcher) {
        this.m_InputWatcher = inputWatcher;
    }

    public IInputWatcher getInputWatcher() {
        return this.m_InputWatcher;
    }

    public void notifyInputChange(String id, String value) {
        if (this.m_InputWatcher != null) {
            this.m_InputWatcher.onInputChange(id, value);
        }
    }

    public void registerActionRenderer(String actionElementType, IBaseActionElementRenderer actionRenderer) {
        if (TextUtils.isEmpty((CharSequence)actionElementType)) {
            throw new IllegalArgumentException("cardElementType is null");
        }
        if (actionRenderer == null) {
            throw new IllegalArgumentException("renderer is null");
        }
        this.m_typeToRenderActionMap.put(actionElementType, actionRenderer);
    }

    public IBaseActionElementRenderer getActionRenderer(String actionElementType) {
        return this.m_typeToRenderActionMap.get(actionElementType);
    }

    public void registerActionLayoutRenderer(IActionLayoutRenderer actionLayoutRenderer) {
        this.m_actionLayoutRenderer = actionLayoutRenderer;
    }

    public IOnlineMediaLoader getOnlineMediaLoader() {
        return this.m_onlineMediaLoader;
    }

    public void registerOnlineMediaLoader(IOnlineMediaLoader onlineMediaLoader) {
        this.m_onlineMediaLoader = onlineMediaLoader;
    }

    @Deprecated
    public void registerOnlineImageLoader(IOnlineImageLoader imageLoader) {
        this.m_onlineImageLoader = imageLoader;
    }

    @Deprecated
    public IOnlineImageLoader getOnlineImageLoader() {
        return this.m_onlineImageLoader;
    }

    public void registerResourceResolver(String scheme, IResourceResolver resolver) {
        this.m_resourceResolvers.put(scheme, resolver);
    }

    public IResourceResolver getResourceResolver(String scheme) {
        return this.m_resourceResolvers.get(scheme);
    }

    public IActionLayoutRenderer getActionLayoutRenderer() {
        return this.m_actionLayoutRenderer;
    }

    public void registerFeatureRegistration(FeatureRegistration featureRegistration) {
        this.m_featureRegistration = featureRegistration;
    }

    public FeatureRegistration getFeatureRegistration() {
        return this.m_featureRegistration;
    }

    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, Object tag, BaseCardElementVector baseCardElementList, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) throws AdaptiveFallbackException {
        long size;
        if (baseCardElementList == null || (size = (long)baseCardElementList.size()) <= 0L) {
            return viewGroup;
        }
        LinearLayout layout2 = new LinearLayout(context);
        layout2.setTag(tag);
        layout2.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        layout2.setOrientation(1);
        layout2.setClipChildren(false);
        layout2.setClipToPadding(false);
        VerticalContentAlignment verticalContentAlignment = VerticalContentAlignment.Top;
        if (tag instanceof BaseCardElement) {
            if (tag instanceof Column) {
                Column column = (Column)tag;
                verticalContentAlignment = column.GetVerticalContentAlignment();
            } else if (tag instanceof Container) {
                Container container = (Container)tag;
                verticalContentAlignment = container.GetVerticalContentAlignment();
            }
        } else if (tag instanceof AdaptiveCard) {
            AdaptiveCard adaptiveCard = (AdaptiveCard)tag;
            verticalContentAlignment = adaptiveCard.GetVerticalContentAlignment();
        }
        FeatureRegistration featureRegistration = CardRendererRegistration.getInstance().getFeatureRegistration();
        int i = 0;
        while ((long)i < size) {
            BaseCardElement cardElement = baseCardElementList.get(i);
            this.renderElementAndPerformFallback(renderedCard, context, fragmentManager, cardElement, (ViewGroup)layout2, cardActionHandler, hostConfig, renderArgs, featureRegistration);
            ++i;
        }
        if (verticalContentAlignment != VerticalContentAlignment.Top) {
            LinearLayout verticalAlignmentLayout = new LinearLayout(context);
            verticalAlignmentLayout.setOrientation(0);
            verticalAlignmentLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
            layout2.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            if (verticalContentAlignment == VerticalContentAlignment.Center) {
                verticalAlignmentLayout.setGravity(16);
            } else {
                verticalAlignmentLayout.setGravity(80);
            }
            verticalAlignmentLayout.addView((View)layout2);
            if (viewGroup != null) {
                viewGroup.addView((View)verticalAlignmentLayout);
            }
        } else if (viewGroup != null) {
            viewGroup.addView((View)layout2);
        }
        return layout2;
    }

    public void renderElementAndPerformFallback(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, BaseCardElement cardElement, ViewGroup viewGroup, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs, FeatureRegistration featureRegistration) throws AdaptiveFallbackException {
        IBaseCardElementRenderer renderer = this.m_typeToRendererMap.get(cardElement.GetElementTypeString());
        boolean elementHasFallback = cardElement.GetFallbackType() != FallbackType.None;
        RenderArgs childRenderArgs = new RenderArgs(renderArgs);
        childRenderArgs.setAncestorHasFallback(elementHasFallback || renderArgs.getAncestorHasFallback());
        try {
            if (renderer == null) {
                throw new AdaptiveFallbackException(cardElement);
            }
            if (featureRegistration != null && !cardElement.MeetsRequirements(featureRegistration)) {
                throw new AdaptiveFallbackException(cardElement, featureRegistration);
            }
            renderer.render(renderedCard, context, fragmentManager, viewGroup, cardElement, cardActionHandler, hostConfig, childRenderArgs);
        }
        catch (AdaptiveFallbackException e) {
            if (elementHasFallback) {
                if (cardElement.GetFallbackType() == FallbackType.Content) {
                    BaseElement fallbackElement = cardElement.GetFallbackContent();
                    while (fallbackElement != null) {
                        try {
                            BaseCardElement fallbackCardElement = null;
                            if (fallbackElement instanceof BaseCardElement) {
                                fallbackCardElement = (BaseCardElement)fallbackElement;
                            } else {
                                fallbackCardElement = BaseCardElement.dynamic_cast(fallbackElement);
                                if (fallbackCardElement == null) {
                                    throw new InternalError("Unable to convert BaseElement to BaseCardElement object model.");
                                }
                            }
                            IBaseCardElementRenderer fallbackRenderer = this.m_typeToRendererMap.get(fallbackElement.GetElementTypeString());
                            if (fallbackRenderer == null) {
                                throw new AdaptiveFallbackException(fallbackCardElement);
                            }
                            if (featureRegistration != null && !cardElement.MeetsRequirements(featureRegistration)) {
                                throw new AdaptiveFallbackException(fallbackCardElement, featureRegistration);
                            }
                            renderedCard.addWarning(new AdaptiveWarning(1, "Performing fallback for '" + cardElement.GetElementTypeString() + "' (fallback element type: '" + fallbackCardElement.GetElementTypeString() + "')"));
                            fallbackRenderer.render(renderedCard, context, fragmentManager, viewGroup, fallbackCardElement, cardActionHandler, hostConfig, childRenderArgs);
                        }
                        catch (AdaptiveFallbackException e2) {
                            if (fallbackElement.GetFallbackType() == FallbackType.Content) {
                                fallbackElement = fallbackElement.GetFallbackContent();
                                continue;
                            }
                            fallbackElement = null;
                        }
                    }
                }
                if (cardElement.GetFallbackType() == FallbackType.Drop) {
                    renderedCard.addWarning(new AdaptiveWarning(1, "Dropping element '" + cardElement.GetElementTypeString() + "' for fallback"));
                }
            }
            if (renderArgs.getAncestorHasFallback()) {
                throw e;
            }
            renderedCard.addWarning(new AdaptiveWarning(1, "Unsupported card element type: " + cardElement.GetElementTypeString()));
        }
    }
}

