/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.inputhandler;

import android.support.v4.app.FragmentManager;
import android.widget.EditText;
import io.adaptivecards.objectmodel.BaseInputElement;
import io.adaptivecards.renderer.inputhandler.TextInputHandler;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateInputHandler
extends TextInputHandler {
    private FragmentManager m_fragmentManager;
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static DateFormat s_simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public DateInputHandler(BaseInputElement baseInputElement, FragmentManager fragmentManager) {
        super(baseInputElement);
        this.m_fragmentManager = fragmentManager;
        s_simpleDateFormat.setLenient(false);
    }

    public FragmentManager getFragmentManager() {
        return this.m_fragmentManager;
    }

    @Override
    public String getInput() {
        EditText editText = this.getEditText();
        try {
            Date date = DateFormat.getDateInstance().parse(editText.getText().toString());
            return s_simpleDateFormat.format(date);
        }
        catch (ParseException e) {
            return editText.getText().toString();
        }
    }
}

