/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.layout;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.media.MediaPlayer;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import io.adaptivecards.renderer.layout.FullscreenVideoView;
import java.util.Locale;

public class FullscreenVideoLayout
extends FullscreenVideoView
implements View.OnClickListener,
SeekBar.OnSeekBarChangeListener,
MediaPlayer.OnPreparedListener,
View.OnTouchListener {
    protected static Handler TIME_THREAD = null;
    protected Runnable updateTimeRunnable = new Runnable(){

        @Override
        public void run() {
            FullscreenVideoLayout.this.updateCounter();
            TIME_THREAD.postDelayed((Runnable)this, 200L);
        }
    };
    protected View.OnTouchListener m_touchListener;
    protected ViewGroup m_videoControlsView;
    protected SeekBar m_seekBar;
    protected ImageButton m_playButton;
    protected TextView m_elapsedTimeView;
    protected TextView m_totalTimeView;

    public FullscreenVideoLayout(Context context) {
        super(context);
    }

    public FullscreenVideoLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public FullscreenVideoLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void release() {
        super.release();
        super.setOnTouchListener(null);
    }

    private void arrangeControlBar() {
        LinearLayout controlsAndSeekBarLayout = new LinearLayout(this.m_context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1);
        params.gravity = 80;
        controlsAndSeekBarLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        controlsAndSeekBarLayout.setOrientation(1);
        this.m_videoControlsView.addView((View)controlsAndSeekBarLayout);
        this.m_seekBar = new SeekBar(this.m_context);
        this.m_seekBar.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -2));
        controlsAndSeekBarLayout.addView((View)this.m_seekBar);
        LinearLayout controlsBarLayout = new LinearLayout(this.m_context);
        controlsBarLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        controlsBarLayout.setOrientation(0);
        controlsAndSeekBarLayout.addView((View)controlsBarLayout);
        LinearLayout elapsedTimeViewLayout = new LinearLayout(this.m_context);
        elapsedTimeViewLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        elapsedTimeViewLayout.setOrientation(0);
        this.m_elapsedTimeView = new TextView(this.m_context);
        LinearLayout.LayoutParams elapsedTimeViewLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        elapsedTimeViewLayoutParams.gravity = 16;
        this.m_elapsedTimeView.setLayoutParams((ViewGroup.LayoutParams)elapsedTimeViewLayoutParams);
        this.m_elapsedTimeView.setTextColor(-1);
        elapsedTimeViewLayout.addView((View)this.m_elapsedTimeView);
        controlsBarLayout.addView((View)elapsedTimeViewLayout);
        this.m_playButton = new ImageButton(this.m_context);
        controlsBarLayout.addView((View)this.m_playButton);
        LinearLayout totalTimeViewLayout = new LinearLayout(this.m_context);
        totalTimeViewLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        this.m_totalTimeView = new TextView(this.m_context);
        LinearLayout.LayoutParams totalTimeViewLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        totalTimeViewLayoutParams.gravity = 16;
        this.m_totalTimeView.setLayoutParams((ViewGroup.LayoutParams)totalTimeViewLayoutParams);
        this.m_totalTimeView.setTextAlignment(3);
        this.m_totalTimeView.setTextColor(-1);
        totalTimeViewLayout.addView((View)this.m_totalTimeView);
        controlsBarLayout.addView((View)totalTimeViewLayout);
    }

    @Override
    protected void initObjects() {
        super.initObjects();
        super.setOnTouchListener((View.OnTouchListener)this);
        if (this.m_videoControlsView == null) {
            this.m_videoControlsView = new FrameLayout(this.m_context);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);
            layoutParams.gravity = 80;
            this.m_videoControlsView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.m_videoControlsView.setBackgroundColor(0x44000000);
            this.addView((View)this.m_videoControlsView);
        }
        if (this.m_videoControlsView != null) {
            this.arrangeControlBar();
        }
        if (this.m_playButton != null) {
            this.m_playButton.setOnClickListener((View.OnClickListener)this);
        }
        if (this.m_seekBar != null) {
            this.m_seekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        }
        if (this.m_videoControlsView != null) {
            this.m_videoControlsView.setVisibility(4);
        }
    }

    @Override
    protected void releaseObjects() {
        super.releaseObjects();
        if (this.m_videoControlsView != null) {
            this.removeView((View)this.m_videoControlsView);
        }
    }

    protected void startCounter() {
        if (TIME_THREAD == null) {
            TIME_THREAD = new Handler();
        }
        TIME_THREAD.postDelayed(this.updateTimeRunnable, 200L);
    }

    protected void stopCounter() {
        TIME_THREAD.removeCallbacks(this.updateTimeRunnable);
    }

    protected void updateCounter() {
        if (this.m_elapsedTimeView == null) {
            return;
        }
        int elapsed = this.getCurrentPosition();
        if (elapsed > 0 && elapsed < this.getDuration()) {
            this.m_seekBar.setProgress(elapsed);
            elapsed = Math.round((float)elapsed / 1000.0f);
            long s = elapsed % 60;
            long m = elapsed / 60 % 60;
            long h = elapsed / 3600 % 24;
            if (h > 0L) {
                this.m_elapsedTimeView.setText((CharSequence)String.format(Locale.US, "%d:%02d:%02d", h, m, s));
            } else {
                this.m_elapsedTimeView.setText((CharSequence)String.format(Locale.US, "%02d:%02d", m, s));
            }
        }
    }

    public void setOnTouchListener(View.OnTouchListener l) {
        this.m_touchListener = l;
    }

    @Override
    public void onCompletion(MediaPlayer mp) {
        super.onCompletion(mp);
        this.stopCounter();
        this.updateControls();
        if (this.m_currentState != FullscreenVideoView.State.ERROR) {
            this.updateCounter();
        }
    }

    @Override
    public boolean onError(MediaPlayer mp, int what, int extra) {
        boolean result = super.onError(mp, what, extra);
        this.stopCounter();
        this.updateControls();
        return result;
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.getCurrentState() == FullscreenVideoView.State.END) {
            this.stopCounter();
        }
    }

    @Override
    protected void tryToPrepare() {
        super.tryToPrepare();
        if (this.getCurrentState() == FullscreenVideoView.State.PREPARED || this.getCurrentState() == FullscreenVideoView.State.STARTED) {
            int total;
            if (this.m_elapsedTimeView != null && this.m_totalTimeView != null && (total = this.getDuration()) > 0) {
                this.m_seekBar.setMax(total);
                this.m_seekBar.setProgress(0);
                long s = (total /= 1000) % 60;
                long m = total / 60 % 60;
                long h = total / 3600 % 24;
                if (h > 0L) {
                    this.m_elapsedTimeView.setText((CharSequence)"00:00:00");
                    this.m_totalTimeView.setText((CharSequence)String.format(Locale.US, "%d:%02d:%02d", h, m, s));
                } else {
                    this.m_elapsedTimeView.setText((CharSequence)"00:00");
                    this.m_totalTimeView.setText((CharSequence)String.format(Locale.US, "%02d:%02d", m, s));
                }
            }
            if (this.m_videoControlsView != null) {
                this.m_videoControlsView.setVisibility(0);
            }
        }
    }

    @Override
    public void start() throws IllegalStateException {
        if (!this.isPlaying()) {
            super.start();
            this.startCounter();
            this.updateControls();
        }
    }

    @Override
    public void pause() throws IllegalStateException {
        if (this.isPlaying()) {
            this.stopCounter();
            super.pause();
            this.updateControls();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.stopCounter();
        this.updateControls();
    }

    @Override
    public void stop() throws IllegalStateException {
        super.stop();
        this.stopCounter();
        this.updateControls();
    }

    protected void updateControls() {
        if (this.m_playButton == null) {
            return;
        }
        Drawable icon = this.getCurrentState() == FullscreenVideoView.State.STARTED ? this.m_context.getResources().getDrawable(17301539) : this.m_context.getResources().getDrawable(17301540);
        this.m_playButton.setBackground(icon);
    }

    public void hideControls() {
        if (this.m_videoControlsView != null) {
            this.m_videoControlsView.setVisibility(4);
        }
    }

    public void showControls() {
        if (this.m_videoControlsView != null) {
            this.m_videoControlsView.setVisibility(0);
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (event.getAction() == 0 && this.m_videoControlsView != null) {
            if (this.m_videoControlsView.getVisibility() == 0) {
                this.hideControls();
            } else {
                this.showControls();
            }
        }
        if (this.m_touchListener != null) {
            return this.m_touchListener.onTouch((View)this, event);
        }
        return false;
    }

    public void onClick(View v) {
        if (this.isPlaying()) {
            this.pause();
        } else {
            this.start();
        }
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
        this.stopCounter();
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        int progress = seekBar.getProgress();
        this.seekTo(progress);
    }
}

