/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.input;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.TimeInput;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.input.TextInputRenderer;
import io.adaptivecards.renderer.input.TimePickerFragment;
import io.adaptivecards.renderer.inputhandler.TimeInputHandler;
import io.adaptivecards.renderer.readonly.RendererUtil;
import java.text.DateFormat;

public class TimeInputRenderer
extends TextInputRenderer {
    private static TimeInputRenderer s_instance = null;
    private static final String TITLE = "Set Time";

    protected TimeInputRenderer() {
    }

    public static TimeInputRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new TimeInputRenderer();
        }
        return s_instance;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, final Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) {
        if (!hostConfig.GetSupportsInteractivity()) {
            renderedCard.addWarning(new AdaptiveWarning(3, "Input.Time is not allowed"));
            return null;
        }
        TimeInput timeInput = null;
        if (baseCardElement instanceof TimeInput) {
            timeInput = (TimeInput)baseCardElement;
        } else {
            timeInput = TimeInput.dynamic_cast(baseCardElement);
            if (timeInput == null) {
                throw new InternalError("Unable to convert BaseCardElement to TimeInput object model.");
            }
        }
        View separator = TimeInputRenderer.setSpacingAndSeparator(context, viewGroup, timeInput.GetSpacing(), timeInput.GetSeparator(), hostConfig, true);
        TimeInputHandler timeInputHandler = new TimeInputHandler(timeInput, fragmentManager);
        String time = TimeInputRenderer.getTimeFormat().format(RendererUtil.getTime(timeInput.GetValue()).getTime());
        TagContent tagContent = new TagContent(timeInput, timeInputHandler, separator, viewGroup);
        EditText editText = this.renderInternal(renderedCard, context, viewGroup, timeInput, time, timeInput.GetPlaceholder(), timeInputHandler, hostConfig, tagContent);
        editText.setRawInputType(0);
        editText.setFocusable(false);
        editText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TagContent tagContent = (TagContent)v.getTag();
                TimeInputHandler timeInputHandler = (TimeInputHandler)tagContent.GetInputHandler();
                TimeInput timeInput = (TimeInput)timeInputHandler.getBaseInputElement();
                TimePickerFragment timePickerFragment = new TimePickerFragment();
                timePickerFragment.initialize(timeInput, (EditText)v, context);
                Bundle args = new Bundle();
                args.putString("title", TimeInputRenderer.TITLE);
                timePickerFragment.setArguments(args);
                FragmentManager fm = timeInputHandler.getFragmentManager();
                timePickerFragment.show(fm, TimeInputRenderer.TITLE);
            }
        });
        editText.setTag((Object)tagContent);
        TimeInputRenderer.setVisibility(baseCardElement.GetIsVisible(), (View)editText);
        return editText;
    }

    public static DateFormat getTimeFormat() {
        return DateFormat.getTimeInstance(3);
    }
}

