/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.support.v4.app.FragmentManager;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ClickableSpan;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.FontType;
import io.adaptivecards.objectmodel.ForegroundColor;
import io.adaptivecards.objectmodel.HeightType;
import io.adaptivecards.objectmodel.HorizontalAlignment;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.TextBlock;
import io.adaptivecards.objectmodel.TextSize;
import io.adaptivecards.objectmodel.TextWeight;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.readonly.DateTimeParser;
import io.adaptivecards.renderer.readonly.RendererUtil;
import io.adaptivecards.renderer.readonly.TextRendererUtil;
import java.util.HashMap;

public class TextBlockRenderer
extends BaseCardElementRenderer {
    private static TextBlockRenderer s_instance = null;
    private HashMap<TextWeight, Integer> m_textWeightMap = new HashMap();
    private final int g_textWeightDefault = 0;
    private final int g_textWeightBolder = 1;
    private final int g_textWeightLighter = 2;

    protected TextBlockRenderer() {
        this.m_textWeightMap.put(TextWeight.Default, 0);
        this.m_textWeightMap.put(TextWeight.Bolder, 1);
        this.m_textWeightMap.put(TextWeight.Lighter, 2);
    }

    public static TextBlockRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new TextBlockRenderer();
        }
        return s_instance;
    }

    static void setTextAlignment(TextView textView, HorizontalAlignment textAlignment) {
        textView.setGravity(TextRendererUtil.getTextAlignment(textAlignment));
    }

    static void setTextSize(TextView textView, FontType type, TextSize textSize, HostConfig hostConfig) {
        textView.setTextSize((float)TextRendererUtil.getTextSize(type, textSize, hostConfig));
    }

    void setTextFormat(TextView textView, HostConfig hostConfig, FontType type, TextWeight textWeight) {
        textView.setTypeface(TextRendererUtil.getTextFormat(hostConfig, type), this.m_textWeightMap.get((Object)textWeight).intValue());
    }

    static void setTextColor(TextView textView, ForegroundColor foregroundColor, HostConfig hostConfig, boolean isSubtle, ContainerStyle containerStyle) {
        textView.setTextColor(TextBlockRenderer.getColor(TextRendererUtil.getTextColor(foregroundColor, hostConfig, isSubtle, containerStyle)));
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) {
        TextBlock textBlock = null;
        if (baseCardElement instanceof TextBlock) {
            textBlock = (TextBlock)baseCardElement;
        } else {
            textBlock = TextBlock.dynamic_cast(baseCardElement);
            if (textBlock == null) {
                throw new InternalError("Unable to convert BaseCardElement to TextBlock object model.");
            }
        }
        TextView textView = new TextView(context);
        View separator = TextBlockRenderer.setSpacingAndSeparator(context, viewGroup, textBlock.GetSpacing(), textBlock.GetSeparator(), hostConfig, true);
        textView.setTag((Object)new TagContent(textBlock, separator, viewGroup));
        TextBlockRenderer.setVisibility(baseCardElement.GetIsVisible(), (View)textView);
        DateTimeParser parser = new DateTimeParser(textBlock.GetLanguage());
        String textWithFormattedDates = parser.GenerateString(textBlock.GetTextForDateParsing());
        CharSequence text = RendererUtil.handleSpecialText(textWithFormattedDates);
        textView.setText(text);
        if (!textBlock.GetWrap()) {
            textView.setMaxLines(1);
        }
        textView.setEllipsize(TextUtils.TruncateAt.END);
        textView.setOnTouchListener((View.OnTouchListener)new TouchTextView((Spannable)new SpannableString(text)));
        textView.setHorizontallyScrolling(false);
        this.setTextFormat(textView, hostConfig, textBlock.GetFontType(), textBlock.GetTextWeight());
        TextBlockRenderer.setTextSize(textView, textBlock.GetFontType(), textBlock.GetTextSize(), hostConfig);
        TextBlockRenderer.setTextColor(textView, textBlock.GetTextColor(), hostConfig, textBlock.GetIsSubtle(), renderArgs.getContainerStyle());
        TextBlockRenderer.setTextAlignment(textView, textBlock.GetHorizontalAlignment());
        if (textBlock.GetHeight() == HeightType.Stretch) {
            textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        } else {
            textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        }
        int maxLines = (int)textBlock.GetMaxLines();
        if (maxLines > 0 && textBlock.GetWrap()) {
            textView.setMaxLines(maxLines);
        } else if (!textBlock.GetWrap()) {
            textView.setMaxLines(1);
        }
        viewGroup.addView((View)textView);
        return textView;
    }

    static class TouchTextView
    implements View.OnTouchListener {
        Spannable spannable;

        public TouchTextView(Spannable spannable) {
            this.spannable = spannable;
        }

        public boolean onTouch(View v, MotionEvent event) {
            int action = event.getAction();
            if (!(v instanceof TextView)) {
                return false;
            }
            TextView textView = (TextView)v;
            if (action == 1 || action == 0) {
                int line;
                int x = (int)event.getX();
                int y = (int)event.getY();
                x -= textView.getTotalPaddingLeft();
                y -= textView.getTotalPaddingTop();
                Layout layout2 = textView.getLayout();
                int off = layout2.getOffsetForHorizontal(line = layout2.getLineForVertical(y += textView.getScrollY()), (float)(x += textView.getScrollX()));
                ClickableSpan[] link = (ClickableSpan[])this.spannable.getSpans(off, off, ClickableSpan.class);
                if (link.length != 0) {
                    if (action == 1) {
                        link[0].onClick((View)textView);
                    } else if (action == 0) {
                        Selection.setSelection((Spannable)this.spannable, (int)this.spannable.getSpanStart((Object)link[0]), (int)this.spannable.getSpanEnd((Object)link[0]));
                    }
                    return true;
                }
                Selection.removeSelection((Spannable)this.spannable);
            }
            return false;
        }
    }
}

