/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.view.View;
import io.adaptivecards.objectmodel.AdaptiveCard;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.inputhandler.IInputHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class RenderedAdaptiveCard {
    private View view;
    private Vector<AdaptiveWarning> warnings = new Vector();
    private Vector<IInputHandler> handlers = new Vector();
    private AdaptiveCard adaptiveCard;

    protected RenderedAdaptiveCard(AdaptiveCard adaptiveCard) {
        this.adaptiveCard = adaptiveCard;
    }

    public View getView() {
        return this.view;
    }

    public void addWarning(AdaptiveWarning warning) {
        this.warnings.add(warning);
    }

    public Vector<AdaptiveWarning> getWarnings() {
        return this.warnings;
    }

    public void registerInputHandler(IInputHandler handler) {
        this.handlers.add(handler);
    }

    public Map<String, String> getInputs() {
        HashMap<String, String> input = new HashMap<String, String>();
        for (IInputHandler i : this.handlers) {
            input.put(i.getId(), i.getInput());
        }
        return input;
    }

    public void setInputs(Map<String, String> inputs) {
        if (inputs == null || inputs.isEmpty()) {
            return;
        }
        for (IInputHandler handler : this.handlers) {
            if (!inputs.containsKey(handler.getId())) continue;
            handler.setInput(inputs.get(handler.getId()));
        }
    }

    public AdaptiveCard getAdaptiveCard() {
        return this.adaptiveCard;
    }

    public void setView(View view) {
        this.view = view;
    }
}

