/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.graphics.Color;
import android.os.AsyncTask;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import io.adaptivecards.objectmodel.AdaptiveCard;
import io.adaptivecards.objectmodel.BackgroundImage;
import io.adaptivecards.objectmodel.BaseActionElement;
import io.adaptivecards.objectmodel.BaseActionElementVector;
import io.adaptivecards.objectmodel.BaseCardElementVector;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.HeightType;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.InternalId;
import io.adaptivecards.objectmodel.VerticalContentAlignment;
import io.adaptivecards.renderer.AdaptiveFallbackException;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.BackgroundImageLoaderAsync;
import io.adaptivecards.renderer.BaseActionElementRenderer;
import io.adaptivecards.renderer.IActionLayoutRenderer;
import io.adaptivecards.renderer.IOnlineImageLoader;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.registration.CardRendererRegistration;

public class AdaptiveCardRenderer {
    public static final String VERSION = "1.3";
    private static AdaptiveCardRenderer s_instance = null;
    private IOnlineImageLoader m_onlineImageLoader = null;
    private HostConfig defaultHostConfig = new HostConfig();

    protected AdaptiveCardRenderer() {
    }

    public static AdaptiveCardRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new AdaptiveCardRenderer();
        }
        return s_instance;
    }

    public RenderedAdaptiveCard render(Context context, FragmentManager fragmentManager, AdaptiveCard adaptiveCard, ICardActionHandler cardActionHandler) {
        return this.render(context, fragmentManager, adaptiveCard, cardActionHandler, this.defaultHostConfig);
    }

    public RenderedAdaptiveCard render(Context context, FragmentManager fragmentManager, AdaptiveCard adaptiveCard, ICardActionHandler cardActionHandler, HostConfig hostConfig) {
        RenderedAdaptiveCard result = new RenderedAdaptiveCard(adaptiveCard);
        View cardView = this.internalRender(result, context, fragmentManager, adaptiveCard, cardActionHandler, hostConfig, false, new InternalId());
        result.setView(cardView);
        return result;
    }

    public View internalRender(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, AdaptiveCard adaptiveCard, ICardActionHandler cardActionHandler, HostConfig hostConfig, boolean isInlineShowCard, InternalId containerCardId) {
        BaseActionElement selectAction;
        boolean cardHasMinHeightSet;
        if (hostConfig == null) {
            throw new IllegalArgumentException("hostConfig is null");
        }
        if (renderedCard == null) {
            throw new IllegalArgumentException("renderedCard is null");
        }
        LinearLayout rootLayout = new LinearLayout(context);
        rootLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        rootLayout.setOrientation(1);
        rootLayout.setFocusable(true);
        rootLayout.setFocusableInTouchMode(true);
        rootLayout.setClipChildren(false);
        rootLayout.setClipToPadding(false);
        LinearLayout layout2 = new LinearLayout(context);
        layout2.setTag((Object)adaptiveCard);
        layout2.setClipChildren(false);
        layout2.setClipToPadding(false);
        boolean bl = cardHasMinHeightSet = adaptiveCard.GetMinHeight() != 0L;
        if (adaptiveCard.GetHeight() == HeightType.Stretch || cardHasMinHeightSet) {
            layout2.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        } else {
            layout2.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        }
        if (cardHasMinHeightSet) {
            rootLayout.setMinimumHeight(Util.dpToPixels(context, (int)adaptiveCard.GetMinHeight()));
        }
        VerticalContentAlignment contentAlignment = adaptiveCard.GetVerticalContentAlignment();
        switch (contentAlignment) {
            case Center: {
                layout2.setGravity(16);
                break;
            }
            case Bottom: {
                layout2.setGravity(80);
                break;
            }
            default: {
                layout2.setGravity(48);
            }
        }
        layout2.setOrientation(1);
        int padding = Util.dpToPixels(context, hostConfig.GetSpacing().getPaddingSpacing());
        layout2.setPadding(padding, padding, padding, padding);
        rootLayout.addView((View)layout2);
        BaseCardElementVector baseCardElementList = adaptiveCard.GetBody();
        ContainerStyle style2 = ContainerStyle.Default;
        if (isInlineShowCard && hostConfig.GetActions().getShowCard().getStyle() != ContainerStyle.None) {
            style2 = hostConfig.GetActions().getShowCard().getStyle();
        }
        if (hostConfig.GetAdaptiveCard().getAllowCustomStyle() && adaptiveCard.GetStyle() != ContainerStyle.None) {
            style2 = adaptiveCard.GetStyle();
        }
        String color = hostConfig.GetBackgroundColor(style2);
        layout2.setBackgroundColor(Color.parseColor((String)color));
        RenderArgs renderArgs = new RenderArgs();
        renderArgs.setContainerStyle(style2);
        renderArgs.setContainerCardId(adaptiveCard.GetInternalId());
        renderedCard.setParentToCard(adaptiveCard.GetInternalId(), containerCardId);
        try {
            CardRendererRegistration.getInstance().render(renderedCard, context, fragmentManager, (ViewGroup)layout2, adaptiveCard, baseCardElementList, cardActionHandler, hostConfig, renderArgs);
        }
        catch (AdaptiveFallbackException adaptiveFallbackException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (hostConfig.GetSupportsInteractivity()) {
            BaseActionElementVector baseActionElementList = adaptiveCard.GetActions();
            if (baseActionElementList != null && baseActionElementList.size() > 0) {
                LinearLayout showCardsLayout = new LinearLayout(context);
                showCardsLayout.setBackgroundColor(Color.parseColor((String)color));
                showCardsLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
                rootLayout.addView((View)showCardsLayout);
                IActionLayoutRenderer actionLayoutRenderer = CardRendererRegistration.getInstance().getActionLayoutRenderer();
                if (actionLayoutRenderer != null) {
                    try {
                        actionLayoutRenderer.renderActions(renderedCard, context, fragmentManager, (ViewGroup)layout2, baseActionElementList, cardActionHandler, hostConfig, renderArgs);
                    }
                    catch (AdaptiveFallbackException adaptiveFallbackException) {}
                }
            }
        } else {
            renderedCard.addWarning(new AdaptiveWarning(3, "Interactivity is not allowed. Actions not rendered."));
        }
        BackgroundImage backgroundImageProperties = adaptiveCard.GetBackgroundImage();
        if (backgroundImageProperties != null && !backgroundImageProperties.GetUrl().isEmpty()) {
            BackgroundImageLoaderAsync loaderAsync = new BackgroundImageLoaderAsync(renderedCard, context, layout2, hostConfig.GetImageBaseUrl(), context.getResources().getDisplayMetrics().widthPixels, backgroundImageProperties);
            IOnlineImageLoader onlineImageLoader = CardRendererRegistration.getInstance().getOnlineImageLoader();
            if (onlineImageLoader != null) {
                loaderAsync.registerCustomOnlineImageLoader(onlineImageLoader);
            }
            loaderAsync.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[]{backgroundImageProperties.GetUrl()});
        }
        if ((selectAction = renderedCard.getAdaptiveCard().GetSelectAction()) != null) {
            rootLayout.setClickable(true);
            rootLayout.setOnClickListener((View.OnClickListener)new BaseActionElementRenderer.SelectActionOnClickListener(renderedCard, selectAction, cardActionHandler));
        }
        return rootLayout;
    }
}

