/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import io.adaptivecards.objectmodel.BaseActionElement;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.CharVector;
import java.lang.reflect.Method;

public final class Util {
    public static int dpToPixels(Context context, long dp) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        int returnVal = (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)metrics);
        return returnVal;
    }

    public static byte[] getBytes(CharVector charVector) {
        long vectorSize = charVector.size();
        byte[] byteArray = new byte[(int)vectorSize];
        int i = 0;
        while ((long)i < vectorSize) {
            byteArray[i] = (byte)charVector.get(i).charValue();
            ++i;
        }
        return byteArray;
    }

    public static void MoveChildrenViews(ViewGroup origin, ViewGroup destination) {
        int childCount = origin.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View v = origin.getChildAt(i);
            origin.removeView(v);
            destination.addView(v);
        }
    }

    public static <T extends BaseCardElement> boolean isOfType(BaseCardElement cardElement, Class<T> cardElementType) {
        return Util.tryCastTo(cardElement, cardElementType) != null;
    }

    public static <T extends BaseCardElement> T tryCastTo(BaseCardElement cardElement, Class<T> cardElementType) {
        try {
            return Util.castTo(cardElement, cardElementType);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T extends BaseCardElement> T castTo(BaseCardElement cardElement, Class<T> cardElementType) throws ClassCastException {
        try {
            BaseCardElement castedElement = null;
            if (cardElementType.isAssignableFrom(cardElement.getClass())) {
                castedElement = cardElement;
            } else {
                Method dynamicCastMethod = cardElementType.getMethod("dynamic_cast", BaseCardElement.class);
                castedElement = (BaseCardElement)dynamicCastMethod.invoke(null, cardElement);
                if (castedElement == null) {
                    throw new InternalError("Unable to convert " + cardElement.getClass().getName() + " to " + cardElementType.getName() + " object model.");
                }
            }
            return (T)castedElement;
        }
        catch (Exception e) {
            throw new ClassCastException("Unable to find dynamic_cast method in " + cardElementType.getName() + ".");
        }
    }

    public static <T extends BaseActionElement> boolean isOfType(BaseActionElement actionElement, Class<T> actionElementType) {
        return Util.tryCastTo(actionElement, actionElementType) != null;
    }

    public static <T extends BaseActionElement> T tryCastTo(BaseActionElement actionElement, Class<T> actionElementType) {
        try {
            return Util.castTo(actionElement, actionElementType);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T extends BaseActionElement> T castTo(BaseActionElement actionElement, Class<T> actionElementType) throws ClassCastException {
        try {
            BaseActionElement castedElement = null;
            if (actionElementType.isAssignableFrom(actionElement.getClass())) {
                castedElement = actionElement;
            } else {
                Method dynamicCastMethod = actionElementType.getMethod("dynamic_cast", BaseActionElement.class);
                castedElement = (BaseActionElement)dynamicCastMethod.invoke(null, actionElement);
                if (castedElement == null) {
                    throw new InternalError("Unable to convert " + actionElement.getClass().getName() + " to " + actionElementType.getName() + " object model.");
                }
            }
            return (T)castedElement;
        }
        catch (Exception e) {
            throw new ClassCastException("Unable to find dynamic_cast method in " + actionElementType.getName() + ".");
        }
    }
}

