/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.action;

import android.content.Context;
import android.graphics.Color;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import io.adaptivecards.objectmodel.ActionSet;
import io.adaptivecards.objectmodel.BaseActionElementVector;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.renderer.ActionLayoutRenderer;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;

public class ActionSetRenderer
extends BaseCardElementRenderer {
    private static ActionSetRenderer s_instance = null;

    public static ActionSetRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ActionSetRenderer();
        }
        return s_instance;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) throws ClassCastException {
        ActionSet actionSet = Util.castTo(baseCardElement, ActionSet.class);
        LinearLayout rootLayout = new LinearLayout(context);
        rootLayout.setTag((Object)new TagContent(actionSet));
        rootLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        rootLayout.setOrientation(1);
        rootLayout.setFocusable(true);
        rootLayout.setFocusableInTouchMode(true);
        LinearLayout actionsLayout = new LinearLayout(context);
        actionsLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        ContainerStyle style2 = renderArgs.getContainerStyle();
        String color = hostConfig.GetBackgroundColor(style2);
        actionsLayout.setBackgroundColor(Color.parseColor((String)color));
        rootLayout.addView((View)actionsLayout);
        LinearLayout showCardsLayout = new LinearLayout(context);
        showCardsLayout.setBackgroundColor(Color.parseColor((String)color));
        showCardsLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        rootLayout.addView((View)showCardsLayout);
        BaseActionElementVector baseActionElementList = actionSet.GetActions();
        try {
            ActionLayoutRenderer.getInstance().renderActions(renderedCard, context, fragmentManager, (ViewGroup)actionsLayout, baseActionElementList, cardActionHandler, hostConfig, renderArgs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        viewGroup.addView((View)rootLayout);
        return rootLayout;
    }
}

