/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.inputhandler;

import android.widget.Spinner;
import io.adaptivecards.objectmodel.BaseInputElement;
import io.adaptivecards.objectmodel.ChoiceInput;
import io.adaptivecards.objectmodel.ChoiceInputVector;
import io.adaptivecards.objectmodel.ChoiceSetInput;
import io.adaptivecards.renderer.inputhandler.BaseInputHandler;

public class ComboBoxInputHandler
extends BaseInputHandler {
    public ComboBoxInputHandler(BaseInputElement baseInputElement) {
        super(baseInputElement);
    }

    protected Spinner getSpinner() {
        return (Spinner)this.m_view;
    }

    @Override
    public String getInput() {
        ChoiceSetInput choiceSetInput = (ChoiceSetInput)this.m_baseInputElement;
        int index = this.getSpinner().getSelectedItemPosition();
        String selectedItem = "";
        if (index >= 0 && index < choiceSetInput.GetChoices().size()) {
            selectedItem = choiceSetInput.GetChoices().get(index).GetValue();
        }
        return selectedItem;
    }

    @Override
    public void setInput(String value) {
        ChoiceSetInput choiceSetInput = (ChoiceSetInput)this.m_baseInputElement;
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        int selectedPosition = 0;
        for (int i = 0; i < choiceInputVector.size(); ++i) {
            ChoiceInput choiceInput = choiceInputVector.get(i);
            if (!value.equals(choiceInput.GetValue())) continue;
            selectedPosition = i;
            break;
        }
        this.getSpinner().setSelection(selectedPosition);
    }

    @Override
    public void setFocusToView() {
        this.m_view.requestFocus();
        this.m_view.performClick();
    }
}

