/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.inputhandler;

import android.widget.EditText;
import io.adaptivecards.objectmodel.BaseInputElement;
import io.adaptivecards.objectmodel.NumberInput;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.inputhandler.TextInputHandler;

public class NumberInputHandler
extends TextInputHandler {
    public NumberInputHandler(BaseInputElement baseInputElement) {
        super(baseInputElement);
    }

    @Override
    protected EditText getEditText() {
        return (EditText)this.m_view;
    }

    @Override
    public void setInput(String text) {
        this.getEditText().setText((CharSequence)text);
    }

    @Override
    public String getInput() {
        return this.getEditText().getText().toString();
    }

    @Override
    public boolean isValidOnSpecifics(String numberInputValue) {
        NumberInput numberInput = Util.tryCastTo(this.m_baseInputElement, NumberInput.class);
        if (numberInput == null) {
            return false;
        }
        int inputValue = 0;
        try {
            inputValue = Integer.parseInt(numberInputValue);
        }
        catch (Exception ex) {
            return false;
        }
        boolean isValid = true;
        if (numberInput.GetMin() != null) {
            boolean bl = isValid = numberInput.GetMin() <= inputValue;
        }
        if (numberInput.GetMax() != null) {
            isValid = isValid && inputValue <= numberInput.GetMax();
        }
        return isValid;
    }
}

