/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.inputhandler;

import android.widget.EditText;
import io.adaptivecards.objectmodel.BaseInputElement;
import io.adaptivecards.objectmodel.TextInput;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.inputhandler.BaseInputHandler;
import java.util.regex.Pattern;

public class TextInputHandler
extends BaseInputHandler {
    public TextInputHandler(BaseInputElement baseInputElement) {
        super(baseInputElement);
    }

    protected EditText getEditText() {
        return (EditText)this.m_view;
    }

    @Override
    public void setInput(String text) {
        this.getEditText().setText((CharSequence)text);
    }

    @Override
    public String getInput() {
        return this.getEditText().getText().toString();
    }

    @Override
    public boolean isValidOnSpecifics(String textInputValue) {
        TextInput textInput = Util.tryCastTo(this.m_baseInputElement, TextInput.class);
        if (textInput == null) {
            return false;
        }
        boolean isValid = true;
        String regex = textInput.GetRegex();
        if (!regex.isEmpty()) {
            isValid = Pattern.matches(regex, textInputValue);
        }
        return isValid;
    }

    @Override
    public void setFocusToView() {
        this.m_view.requestFocus();
    }
}

