/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.inputhandler;

import android.support.v4.app.FragmentManager;
import android.widget.EditText;
import io.adaptivecards.objectmodel.BaseInputElement;
import io.adaptivecards.objectmodel.TimeInput;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.input.TimeInputRenderer;
import io.adaptivecards.renderer.inputhandler.TextInputHandler;
import io.adaptivecards.renderer.readonly.RendererUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TimeInputHandler
extends TextInputHandler {
    private FragmentManager m_fragmentManager;
    public static final String TIME_FORMAT_SUBMIT = "kk:mm";
    public static SimpleDateFormat s_simpleDateFormat = new SimpleDateFormat("kk:mm");

    public TimeInputHandler(BaseInputElement baseInputElement, FragmentManager fragmentManager) {
        super(baseInputElement);
        this.m_fragmentManager = fragmentManager;
    }

    public FragmentManager getFragmentManager() {
        return this.m_fragmentManager;
    }

    @Override
    public String getInput() {
        EditText editText = this.getEditText();
        try {
            Date time = DateFormat.getTimeInstance().parse(editText.getText().toString());
            return s_simpleDateFormat.format(time);
        }
        catch (ParseException e) {
            return editText.getText().toString();
        }
    }

    @Override
    public boolean isValidOnSpecifics(String timeInputValue) {
        Date max;
        Date min;
        TimeInput timeInput = Util.tryCastTo(this.m_baseInputElement, TimeInput.class);
        if (timeInput == null) {
            return false;
        }
        Date currentTime = null;
        try {
            currentTime = this.getCurrentValue(this.getInput());
        }
        catch (Exception e) {
            return false;
        }
        String minTime = timeInput.GetMin();
        if (!minTime.isEmpty() && !this.beforeOrSame(min = RendererUtil.getTime(minTime).getTime(), currentTime)) {
            return false;
        }
        String maxTime = timeInput.GetMax();
        return maxTime.isEmpty() || this.beforeOrSame(currentTime, max = RendererUtil.getTime(maxTime).getTime());
    }

    private Date getCurrentValue(String timeInputValue) throws Exception {
        Date currentTime = TimeInputRenderer.getTimeFormat().parse(timeInputValue);
        Calendar currentValueDate = Calendar.getInstance();
        currentValueDate.setTime(currentTime);
        Date currentDate = new Date();
        Calendar currentDateCalendar = Calendar.getInstance();
        currentDateCalendar.setTime(currentDate);
        currentDateCalendar.set(11, currentValueDate.get(11));
        currentDateCalendar.set(12, currentValueDate.get(12));
        currentTime = currentDateCalendar.getTime();
        return currentTime;
    }

    private boolean beforeOrSame(Date before, Date after) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(before);
        int beforeHour = calendar.get(11);
        int beforeMinute = calendar.get(12);
        calendar.setTime(after);
        int afterHour = calendar.get(11);
        int afterMinute = calendar.get(12);
        return beforeHour < afterHour || beforeHour == afterHour && beforeMinute <= afterMinute;
    }
}

