/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.view.View;
import io.adaptivecards.objectmodel.AdaptiveCard;
import io.adaptivecards.objectmodel.InternalId;
import io.adaptivecards.objectmodel.SubmitAction;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.inputhandler.BaseInputHandler;
import io.adaptivecards.renderer.inputhandler.IInputHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class RenderedAdaptiveCard {
    private View view;
    private Vector<AdaptiveWarning> warnings = new Vector();
    private Vector<IInputHandler> handlers = new Vector();
    private AdaptiveCard adaptiveCard;
    private Map<Long, Long> submitActionCard;
    private Map<Long, Vector<IInputHandler>> inputsInCard;
    private Map<Long, Long> parentCardForCard;
    private Map<String, String> prevalidatedInputs;

    protected RenderedAdaptiveCard(AdaptiveCard adaptiveCard) {
        this.adaptiveCard = adaptiveCard;
        this.submitActionCard = new HashMap<Long, Long>();
        this.inputsInCard = new HashMap<Long, Vector<IInputHandler>>();
        this.parentCardForCard = new HashMap<Long, Long>();
        this.prevalidatedInputs = new HashMap<String, String>();
    }

    public View getView() {
        return this.view;
    }

    public void addWarning(AdaptiveWarning warning) {
        this.warnings.add(warning);
    }

    public Vector<AdaptiveWarning> getWarnings() {
        return this.warnings;
    }

    public void registerInputHandler(IInputHandler handler, InternalId cardId) {
        Long cardHash = cardId.Hash();
        if (!this.inputsInCard.containsKey(cardHash)) {
            this.inputsInCard.put(cardHash, new Vector());
        }
        this.inputsInCard.get(cardHash).add(handler);
        this.handlers.add(handler);
    }

    public Map<String, String> getInputs() {
        return this.prevalidatedInputs;
    }

    public void setParentToCard(InternalId card, InternalId parentCard) {
        this.parentCardForCard.put(card.Hash(), parentCard.Hash());
    }

    public void setCardForSubmitAction(InternalId actionId, InternalId parentCard) {
        this.submitActionCard.put(actionId.Hash(), parentCard.Hash());
    }

    private Vector<IInputHandler> getInputsToValidate(SubmitAction submitAction) {
        Long cardId = this.submitActionCard.get(submitAction.GetInternalId().Hash());
        Vector<IInputHandler> inputHandlers = new Vector<IInputHandler>();
        while (cardId != null && cardId.longValue() != new InternalId().Hash()) {
            Vector<IInputHandler> handlersInCard = this.inputsInCard.get(cardId);
            if (handlersInCard != null) {
                inputHandlers.addAll(handlersInCard);
            }
            cardId = this.parentCardForCard.get(cardId);
        }
        return inputHandlers;
    }

    public boolean areInputsValid(SubmitAction submitAction) {
        boolean allInputsAreValid = true;
        boolean hasSetFocusToElement = false;
        HashMap<String, String> validatedInputs = new HashMap<String, String>();
        Vector<IInputHandler> inputsToValidate = this.getInputsToValidate(submitAction);
        for (IInputHandler i : inputsToValidate) {
            if (allInputsAreValid &= i.isValid()) {
                validatedInputs.put(i.getId(), i.getInput());
            }
            if (allInputsAreValid || hasSetFocusToElement) continue;
            BaseInputHandler baseInputHandler = (BaseInputHandler)i;
            baseInputHandler.setFocusToView();
            hasSetFocusToElement = true;
        }
        if (allInputsAreValid) {
            this.prevalidatedInputs = validatedInputs;
        }
        return allInputsAreValid;
    }

    public void setInputs(Map<String, String> inputs) {
        if (inputs == null || inputs.isEmpty()) {
            return;
        }
        for (IInputHandler handler : this.handlers) {
            if (!inputs.containsKey(handler.getId())) continue;
            handler.setInput(inputs.get(handler.getId()));
        }
    }

    public AdaptiveCard getAdaptiveCard() {
        return this.adaptiveCard;
    }

    public void setView(View view) {
        this.view = view;
    }
}

