/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.action;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import androidx.fragment.app.FragmentManager;
import io.adaptivecards.R;
import io.adaptivecards.objectmodel.BaseActionElement;
import io.adaptivecards.objectmodel.FeatureRegistration;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.IconPlacement;
import io.adaptivecards.renderer.AdaptiveFallbackException;
import io.adaptivecards.renderer.IBaseActionElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.registration.CardRendererRegistration;

public class DropdownElementRenderer
implements IBaseActionElementRenderer {
    private static final int PADDING = 10;
    private static DropdownElementRenderer s_instance = null;

    protected DropdownElementRenderer() {
    }

    public static DropdownElementRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new DropdownElementRenderer();
        }
        return s_instance;
    }

    @Override
    public Button render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseActionElement baseActionElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) throws AdaptiveFallbackException {
        IBaseActionElementRenderer actionRenderer = CardRendererRegistration.getInstance().getActionRenderer(baseActionElement.GetElementTypeString());
        FeatureRegistration featureRegistration = CardRendererRegistration.getInstance().getFeatureRegistration();
        if (actionRenderer == null) {
            throw new AdaptiveFallbackException(baseActionElement);
        }
        if (featureRegistration != null && !baseActionElement.MeetsRequirements(featureRegistration)) {
            throw new AdaptiveFallbackException(baseActionElement, featureRegistration);
        }
        String iconUrl = baseActionElement.GetIconUrl();
        baseActionElement.SetIconUrl("");
        Button button = actionRenderer.render(renderedCard, context, fragmentManager, viewGroup, baseActionElement, cardActionHandler, hostConfig, renderArgs);
        viewGroup.removeView((View)button);
        Button dropDownItem = new Button(context, null, R.style.Widget_AppCompat_Light_ActionButton_Overflow);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        int padding = Util.dpToPixels(context, 10.0f);
        layoutParams.gravity = 17;
        dropDownItem.setText(button.getText());
        dropDownItem.setPadding(padding, padding, padding, padding);
        dropDownItem.setTextSize(2, 14.0f);
        dropDownItem.setGravity(17);
        dropDownItem.setTextColor(context.getResources().getColor(R.color.dropdown_text_color));
        dropDownItem.setBackgroundColor(context.getResources().getColor(17170445));
        dropDownItem.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        dropDownItem.setMinWidth(Util.dpToPixels(context, 100.0f));
        dropDownItem.setMinimumWidth(0);
        if (!iconUrl.isEmpty()) {
            Util.loadIcon(context, (View)dropDownItem, iconUrl, hostConfig, renderedCard, IconPlacement.LeftOfTitle);
        }
        dropDownItem.setOnClickListener(view -> {
            button.performClick();
            try {
                if (view.getParent() instanceof ViewGroup && ((ViewGroup)view.getParent()).getTag() instanceof PopupWindow) {
                    PopupWindow popupWindow = (PopupWindow)((ViewGroup)view.getParent()).getTag();
                    popupWindow.dismiss();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        button.setTag(-1, (Object)viewGroup);
        return dropDownItem;
    }
}

