/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.inputhandler;

import android.view.View;
import android.widget.AutoCompleteTextView;
import io.adaptivecards.objectmodel.BaseInputElement;
import io.adaptivecards.objectmodel.ChoiceInput;
import io.adaptivecards.objectmodel.ChoiceInputVector;
import io.adaptivecards.objectmodel.ChoiceSetInput;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.input.customcontrols.ValidatedInputLayout;
import io.adaptivecards.renderer.inputhandler.AutoCompleteTextViewHandler;
import io.adaptivecards.renderer.inputhandler.BaseInputHandler;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00100\u0012H\u0002J,\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00100\u0012H\u0002J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u001a\u001a\u00020\u0010H\u0016J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0010H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u0010H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/adaptivecards/renderer/inputhandler/AutoCompleteTextViewHandler;", "Lio/adaptivecards/renderer/inputhandler/BaseInputHandler;", "baseInputElement", "Lio/adaptivecards/objectmodel/BaseInputElement;", "(Lio/adaptivecards/objectmodel/BaseInputElement;)V", "autoCompleteTextView", "Landroid/widget/AutoCompleteTextView;", "getAutoCompleteTextView", "()Landroid/widget/AutoCompleteTextView;", "inputIsEmpty", "", "findIndexForChoiceInput", "", "choiceInputVector", "Lio/adaptivecards/objectmodel/ChoiceInputVector;", "expectedValue", "", "retriever", "Lkotlin/Function1;", "Lio/adaptivecards/objectmodel/ChoiceInput;", "findStringForIndex", "index", "findTitleIndex", "title", "findValueIndex", "value", "getInput", "getTitleForValue", "getValueForTitle", "isValidOnSpecifics", "inputValue", "setFocusToView", "", "setInput", "adaptivecards_release"})
public final class AutoCompleteTextViewHandler
extends BaseInputHandler {
    private boolean inputIsEmpty;

    public AutoCompleteTextViewHandler(@Nullable BaseInputElement baseInputElement) {
        super(baseInputElement);
    }

    @NotNull
    protected final AutoCompleteTextView getAutoCompleteTextView() {
        AutoCompleteTextView autoCompleteTextView;
        if (this.m_view instanceof ValidatedInputLayout) {
            View view = this.m_view;
            if (view == null) {
                throw new NullPointerException("null cannot be cast to non-null type io.adaptivecards.renderer.input.customcontrols.ValidatedInputLayout");
            }
            View view2 = ((ValidatedInputLayout)view).getChildAt(0);
            if (view2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.AutoCompleteTextView");
            }
            autoCompleteTextView = (AutoCompleteTextView)view2;
        } else {
            View view = this.m_view;
            if (view == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.AutoCompleteTextView");
            }
            autoCompleteTextView = (AutoCompleteTextView)view;
        }
        return autoCompleteTextView;
    }

    @Override
    @NotNull
    public String getInput() {
        BaseInputElement baseInputElement = this.m_baseInputElement;
        if (baseInputElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type io.adaptivecards.objectmodel.ChoiceSetInput");
        }
        ChoiceSetInput choiceSetInput = (ChoiceSetInput)baseInputElement;
        String inputText = this.getAutoCompleteTextView().getEditableText().toString();
        this.inputIsEmpty = ((CharSequence)inputText).length() == 0;
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        Intrinsics.checkNotNullExpressionValue((Object)choiceInputVector, (String)"choiceSetInput.GetChoices()");
        return this.getValueForTitle(inputText, choiceInputVector);
    }

    @Override
    public void setInput(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        BaseInputElement baseInputElement = this.m_baseInputElement;
        if (baseInputElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type io.adaptivecards.objectmodel.ChoiceSetInput");
        }
        ChoiceSetInput choiceSetInput = (ChoiceSetInput)baseInputElement;
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        Intrinsics.checkNotNullExpressionValue((Object)choiceInputVector, (String)"choiceSetInput.GetChoices()");
        String title = this.getTitleForValue(value, choiceInputVector);
        this.getAutoCompleteTextView().setText((CharSequence)title);
    }

    @Override
    public void setFocusToView() {
        Util.forceFocus(this.m_view);
        this.m_view.sendAccessibilityEvent(32768);
    }

    @Override
    public boolean isValidOnSpecifics(@NotNull String inputValue) {
        Intrinsics.checkNotNullParameter((Object)inputValue, (String)"inputValue");
        if (this.inputIsEmpty) {
            return true;
        }
        BaseInputElement baseInputElement = this.m_baseInputElement;
        if (baseInputElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type io.adaptivecards.objectmodel.ChoiceSetInput");
        }
        ChoiceSetInput choiceSetInput = (ChoiceSetInput)baseInputElement;
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        Intrinsics.checkNotNullExpressionValue((Object)choiceInputVector, (String)"choiceSetInput.GetChoices()");
        return this.findValueIndex(inputValue, choiceInputVector) != -1;
    }

    private final int findIndexForChoiceInput(ChoiceInputVector choiceInputVector, String expectedValue, Function1<? super ChoiceInput, String> retriever) {
        int index = -1;
        int choiceInputVectorSize = choiceInputVector.size();
        for (int i = 0; i < choiceInputVectorSize; ++i) {
            ChoiceInput choiceInput = choiceInputVector.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)choiceInput, (String)"choiceInputVector[i]");
            if (!Intrinsics.areEqual((Object)retriever.invoke((Object)choiceInput), (Object)expectedValue)) continue;
            index = i;
        }
        return index;
    }

    private final int findTitleIndex(String title, ChoiceInputVector choiceInputVector) {
        return this.findIndexForChoiceInput(choiceInputVector, title, (Function1<? super ChoiceInput, String>)((Function1)findTitleIndex.1.INSTANCE));
    }

    private final int findValueIndex(String value, ChoiceInputVector choiceInputVector) {
        return this.findIndexForChoiceInput(choiceInputVector, value, (Function1<? super ChoiceInput, String>)((Function1)findValueIndex.1.INSTANCE));
    }

    private final String findStringForIndex(int index, ChoiceInputVector choiceInputVector, Function1<? super ChoiceInput, String> retriever) {
        String selectedItem = "";
        if (index >= 0 && index < choiceInputVector.size()) {
            ChoiceInput choiceInput = choiceInputVector.get(index);
            Intrinsics.checkNotNullExpressionValue((Object)choiceInput, (String)"choiceInputVector[index]");
            selectedItem = (String)retriever.invoke((Object)choiceInput);
        }
        return selectedItem;
    }

    private final String getTitleForValue(String value, ChoiceInputVector choiceInputVector) {
        int index = this.findValueIndex(value, choiceInputVector);
        return this.findStringForIndex(index, choiceInputVector, (Function1<? super ChoiceInput, String>)((Function1)getTitleForValue.1.INSTANCE));
    }

    private final String getValueForTitle(String title, ChoiceInputVector choiceInputVector) {
        int index = this.findTitleIndex(title, choiceInputVector);
        return this.findStringForIndex(index, choiceInputVector, (Function1<? super ChoiceInput, String>)((Function1)getValueForTitle.1.INSTANCE));
    }
}

