/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.registration;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.fragment.app.FragmentManager;
import com.google.android.flexbox.FlexboxLayout;
import io.adaptivecards.objectmodel.ActionType;
import io.adaptivecards.objectmodel.AdaptiveCardObjectModel;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.BaseCardElementVector;
import io.adaptivecards.objectmodel.BaseElement;
import io.adaptivecards.objectmodel.BaseInputElement;
import io.adaptivecards.objectmodel.CardElementType;
import io.adaptivecards.objectmodel.Column;
import io.adaptivecards.objectmodel.Container;
import io.adaptivecards.objectmodel.FallbackType;
import io.adaptivecards.objectmodel.FeatureRegistration;
import io.adaptivecards.objectmodel.HeightType;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.Image;
import io.adaptivecards.objectmodel.ImageSet;
import io.adaptivecards.objectmodel.Mode;
import io.adaptivecards.renderer.ActionLayoutRenderer;
import io.adaptivecards.renderer.AdaptiveFallbackException;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.IActionLayoutRenderer;
import io.adaptivecards.renderer.IBaseActionElementRenderer;
import io.adaptivecards.renderer.IBaseCardElementRenderer;
import io.adaptivecards.renderer.IOnlineImageLoader;
import io.adaptivecards.renderer.IOnlineMediaLoader;
import io.adaptivecards.renderer.IOverflowActionRenderer;
import io.adaptivecards.renderer.IResourceResolver;
import io.adaptivecards.renderer.OverflowActionLayoutRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.action.ActionElementRenderer;
import io.adaptivecards.renderer.action.ActionSetRenderer;
import io.adaptivecards.renderer.action.DropdownElementRenderer;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.input.ChoiceSetInputRenderer;
import io.adaptivecards.renderer.input.DateInputRenderer;
import io.adaptivecards.renderer.input.InputUtil;
import io.adaptivecards.renderer.input.NumberInputRenderer;
import io.adaptivecards.renderer.input.TextInputRenderer;
import io.adaptivecards.renderer.input.TimeInputRenderer;
import io.adaptivecards.renderer.input.ToggleInputRenderer;
import io.adaptivecards.renderer.inputhandler.BaseInputHandler;
import io.adaptivecards.renderer.inputhandler.IInputHandler;
import io.adaptivecards.renderer.inputhandler.IInputWatcher;
import io.adaptivecards.renderer.layout.StretchableElementLayout;
import io.adaptivecards.renderer.layout.StretchableInputLayout;
import io.adaptivecards.renderer.readonly.ColumnRenderer;
import io.adaptivecards.renderer.readonly.ColumnSetRenderer;
import io.adaptivecards.renderer.readonly.ContainerRenderer;
import io.adaptivecards.renderer.readonly.FactSetRenderer;
import io.adaptivecards.renderer.readonly.ImageRenderer;
import io.adaptivecards.renderer.readonly.ImageSetRenderer;
import io.adaptivecards.renderer.readonly.MediaRenderer;
import io.adaptivecards.renderer.readonly.RichTextBlockRenderer;
import io.adaptivecards.renderer.readonly.TableCellRenderer;
import io.adaptivecards.renderer.readonly.TableRenderer;
import io.adaptivecards.renderer.readonly.TextBlockRenderer;
import java.util.HashMap;

public class CardRendererRegistration {
    private static CardRendererRegistration s_instance = null;
    private IInputWatcher m_InputWatcher = null;
    private HashMap<String, IBaseCardElementRenderer> m_typeToRendererMap = new HashMap();
    private HashMap<String, IBaseActionElementRenderer> m_typeToRenderActionMap = new HashMap();
    private IActionLayoutRenderer m_actionLayoutRenderer = null;
    private IOnlineImageLoader m_onlineImageLoader = null;
    private HashMap<String, IResourceResolver> m_resourceResolvers = new HashMap();
    private IOnlineMediaLoader m_onlineMediaLoader = null;
    private FeatureRegistration m_featureRegistration = null;
    private IOverflowActionRenderer m_overflowActionRenderer = null;
    private IActionLayoutRenderer m_overflowActionLayoutRenderer = null;

    private CardRendererRegistration() {
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.Column), ColumnRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.ColumnSet), ColumnSetRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.Container), ContainerRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.FactSet), FactSetRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.Image), ImageRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.ImageSet), ImageSetRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.Media), MediaRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.RichTextBlock), RichTextBlockRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.TextBlock), TextBlockRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.ActionSet), ActionSetRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.Table), TableRenderer.INSTANCE);
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.TableCell), TableCellRenderer.INSTANCE);
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.TextInput), TextInputRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.NumberInput), NumberInputRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.DateInput), DateInputRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.TimeInput), TimeInputRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.ToggleInput), ToggleInputRenderer.getInstance());
        this.registerRenderer(AdaptiveCardObjectModel.CardElementTypeToString(CardElementType.ChoiceSetInput), ChoiceSetInputRenderer.getInstance());
        this.registerActionRenderer(AdaptiveCardObjectModel.ActionTypeToString(ActionType.Execute), ActionElementRenderer.getInstance());
        this.registerActionRenderer(AdaptiveCardObjectModel.ActionTypeToString(ActionType.Submit), ActionElementRenderer.getInstance());
        this.registerActionRenderer(AdaptiveCardObjectModel.ActionTypeToString(ActionType.ShowCard), ActionElementRenderer.getInstance());
        this.registerActionRenderer(AdaptiveCardObjectModel.ActionTypeToString(ActionType.OpenUrl), ActionElementRenderer.getInstance());
        this.registerActionRenderer(AdaptiveCardObjectModel.ActionTypeToString(ActionType.ToggleVisibility), ActionElementRenderer.getInstance());
        this.registerActionRenderer(AdaptiveCardObjectModel.ModeToString(Mode.Primary), ActionElementRenderer.getInstance());
        this.registerActionRenderer(AdaptiveCardObjectModel.ModeToString(Mode.Secondary), DropdownElementRenderer.getInstance());
        this.m_actionLayoutRenderer = ActionLayoutRenderer.getInstance();
        this.m_overflowActionLayoutRenderer = OverflowActionLayoutRenderer.getInstance();
    }

    public static CardRendererRegistration getInstance() {
        if (s_instance == null) {
            s_instance = new CardRendererRegistration();
        }
        return s_instance;
    }

    public void registerRenderer(String cardElementType, IBaseCardElementRenderer renderer) {
        if (TextUtils.isEmpty((CharSequence)cardElementType)) {
            throw new IllegalArgumentException("cardElementType is null");
        }
        if (renderer == null) {
            throw new IllegalArgumentException("renderer is null");
        }
        this.m_typeToRendererMap.put(cardElementType, renderer);
    }

    public IBaseCardElementRenderer getRenderer(String cardElementType) {
        return this.m_typeToRendererMap.get(cardElementType);
    }

    public void setInputWatcher(IInputWatcher inputWatcher) {
        this.m_InputWatcher = inputWatcher;
    }

    public IInputWatcher getInputWatcher() {
        return this.m_InputWatcher;
    }

    public void notifyInputChange(String id2, String value) {
        if (this.m_InputWatcher != null) {
            this.m_InputWatcher.onInputChange(id2, value);
        }
    }

    public void registerActionRenderer(String actionElementType, IBaseActionElementRenderer actionRenderer) {
        if (TextUtils.isEmpty((CharSequence)actionElementType)) {
            throw new IllegalArgumentException("cardElementType is null");
        }
        if (actionRenderer == null) {
            throw new IllegalArgumentException("renderer is null");
        }
        this.m_typeToRenderActionMap.put(actionElementType, actionRenderer);
    }

    public IBaseActionElementRenderer getActionRenderer(String actionElementType) {
        return this.m_typeToRenderActionMap.get(actionElementType);
    }

    public void registerActionLayoutRenderer(IActionLayoutRenderer actionLayoutRenderer) {
        this.m_actionLayoutRenderer = actionLayoutRenderer;
    }

    public IOnlineMediaLoader getOnlineMediaLoader() {
        return this.m_onlineMediaLoader;
    }

    public void registerOnlineMediaLoader(IOnlineMediaLoader onlineMediaLoader) {
        this.m_onlineMediaLoader = onlineMediaLoader;
    }

    @Deprecated
    public void registerOnlineImageLoader(IOnlineImageLoader imageLoader) {
        this.m_onlineImageLoader = imageLoader;
    }

    @Deprecated
    public IOnlineImageLoader getOnlineImageLoader() {
        return this.m_onlineImageLoader;
    }

    public void registerResourceResolver(String scheme, IResourceResolver resolver) {
        this.m_resourceResolvers.put(scheme, resolver);
    }

    public IResourceResolver getResourceResolver(String scheme) {
        return this.m_resourceResolvers.get(scheme);
    }

    public IActionLayoutRenderer getActionLayoutRenderer() {
        return this.m_actionLayoutRenderer;
    }

    public void registerFeatureRegistration(FeatureRegistration featureRegistration) {
        this.m_featureRegistration = featureRegistration;
    }

    public FeatureRegistration getFeatureRegistration() {
        if (this.m_featureRegistration == null) {
            this.m_featureRegistration = new FeatureRegistration();
        }
        return this.m_featureRegistration;
    }

    public IOverflowActionRenderer getOverflowActionRenderer() {
        return this.m_overflowActionRenderer;
    }

    public void registerOverflowActionRenderer(IOverflowActionRenderer overflowActionRenderer) {
        this.m_overflowActionRenderer = overflowActionRenderer;
    }

    public void registerOverflowActionLayoutRenderer(IActionLayoutRenderer actionLayoutRenderer) {
        this.m_overflowActionLayoutRenderer = actionLayoutRenderer;
    }

    public IActionLayoutRenderer getOverflowActionLayoutRenderer() {
        return this.m_overflowActionLayoutRenderer;
    }

    public View renderElements(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElementVector baseCardElementList, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) throws AdaptiveFallbackException, Exception {
        long size;
        if (baseCardElementList == null || (size = (long)baseCardElementList.size()) <= 0L) {
            return viewGroup;
        }
        FeatureRegistration featureRegistration = CardRendererRegistration.getInstance().getFeatureRegistration();
        int i = 0;
        while ((long)i < size) {
            BaseCardElement cardElement = baseCardElementList.get(i);
            this.renderElementAndPerformFallback(renderedCard, context, fragmentManager, cardElement, viewGroup, cardActionHandler, hostConfig, renderArgs, featureRegistration);
            ++i;
        }
        return viewGroup;
    }

    public void renderElementAndPerformFallback(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, BaseCardElement cardElement, ViewGroup viewGroup, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs, FeatureRegistration featureRegistration) throws AdaptiveFallbackException, Exception {
        IBaseCardElementRenderer renderer = this.m_typeToRendererMap.get(cardElement.GetElementTypeString());
        boolean elementHasFallback = cardElement.GetFallbackType() != FallbackType.None;
        RenderArgs childRenderArgs = new RenderArgs(renderArgs);
        childRenderArgs.setAncestorHasFallback(elementHasFallback || renderArgs.getAncestorHasFallback());
        BaseCardElement renderedElement = null;
        View renderedElementView = null;
        Object mockLayout = Util.isOfType(cardElement, Column.class) ? new FlexboxLayout(context) : new LinearLayout(context);
        try {
            if (renderer == null) {
                throw new AdaptiveFallbackException(cardElement);
            }
            if (featureRegistration != null && !cardElement.MeetsRequirements(featureRegistration)) {
                throw new AdaptiveFallbackException(cardElement, featureRegistration);
            }
            if (cardElement.GetElementType() == CardElementType.ActionSet) {
                renderArgs.setRootLevelActions(false);
            }
            renderedElementView = renderer.render(renderedCard, context, fragmentManager, (ViewGroup)mockLayout, cardElement, cardActionHandler, hostConfig, childRenderArgs);
            renderedElement = cardElement;
        }
        catch (AdaptiveFallbackException e) {
            if (elementHasFallback) {
                if (cardElement.GetFallbackType() == FallbackType.Content) {
                    BaseElement fallbackElement = cardElement.GetFallbackContent();
                    while (fallbackElement != null) {
                        try {
                            BaseCardElement fallbackCardElement = Util.castToBaseCardElement(fallbackElement);
                            IBaseCardElementRenderer fallbackRenderer = this.m_typeToRendererMap.get(fallbackElement.GetElementTypeString());
                            if (fallbackRenderer == null) {
                                throw new AdaptiveFallbackException(fallbackCardElement);
                            }
                            if (featureRegistration != null && !fallbackElement.MeetsRequirements(featureRegistration)) {
                                throw new AdaptiveFallbackException(fallbackCardElement, featureRegistration);
                            }
                            renderedCard.addWarning(new AdaptiveWarning(1, "Performing fallback for '" + cardElement.GetElementTypeString() + "' (fallback element type: '" + fallbackCardElement.GetElementTypeString() + "')"));
                            renderedElementView = fallbackRenderer.render(renderedCard, context, fragmentManager, (ViewGroup)mockLayout, fallbackCardElement, cardActionHandler, hostConfig, childRenderArgs);
                            renderedElement = fallbackCardElement;
                        }
                        catch (AdaptiveFallbackException e2) {
                            fallbackElement = fallbackElement.GetFallbackType() == FallbackType.Content ? fallbackElement.GetFallbackContent() : null;
                            renderedElement = null;
                        }
                    }
                }
                if (cardElement.GetFallbackType() == FallbackType.Drop) {
                    renderedCard.addWarning(new AdaptiveWarning(1, "Dropping element '" + cardElement.GetElementTypeString() + "' for fallback"));
                    renderedElement = null;
                }
            }
            if (renderArgs.getAncestorHasFallback()) {
                throw e;
            }
            renderedCard.addWarning(new AdaptiveWarning(1, "Unsupported card element type: " + cardElement.GetElementTypeString()));
            renderedElement = null;
        }
        if (renderedElement != null && renderedElementView != null) {
            View taggedView = CardRendererRegistration.findElementWithTagContent((ViewGroup)mockLayout);
            TagContent tagContent = BaseCardElementRenderer.getTagContent(taggedView);
            tagContent.SetViewContainer(viewGroup);
            boolean isColumn = Util.isOfType(renderedElement, Column.class);
            CardRendererRegistration.HandleSpacing(context, viewGroup, renderedElement, hostConfig, tagContent, !isColumn);
            BaseInputElement baseInputElement = Util.tryCastTo(renderedElement, BaseInputElement.class);
            if (baseInputElement != null) {
                CardRendererRegistration.HandleLabelAndValidation(renderedCard, (ViewGroup)mockLayout, viewGroup, baseInputElement, context, hostConfig, renderArgs, tagContent);
            } else if (!(renderedElement.GetHeight() != HeightType.Stretch || isColumn || Util.isOfType(renderedElement, Container.class) || Util.isOfType(renderedElement, Image.class) || Util.isOfType(renderedElement, ImageSet.class))) {
                CardRendererRegistration.HandleStretchHeight((ViewGroup)mockLayout, viewGroup, renderedElement, context, tagContent);
            } else {
                Util.MoveChildrenViews((ViewGroup)mockLayout, viewGroup);
            }
            CardRendererRegistration.HandleVisibility(renderedElement, renderedElementView);
        }
    }

    private static void HandleSpacing(Context context, ViewGroup viewGroup, BaseCardElement cardElement, HostConfig hostConfig, TagContent tagContent, boolean isHorizontalSpacing) {
        View separator = BaseCardElementRenderer.setSpacingAndSeparator(context, viewGroup, cardElement.GetSpacing(), cardElement.GetSeparator(), hostConfig, isHorizontalSpacing, false);
        tagContent.SetSeparator(separator);
    }

    private static void HandleVisibility(BaseCardElement element, View renderedElementView) {
        BaseCardElementRenderer.setVisibility(element.GetIsVisible(), renderedElementView);
    }

    private static void HandleLabelAndValidation(RenderedAdaptiveCard renderedCard, ViewGroup mockLayout, ViewGroup container, BaseInputElement element, Context context, HostConfig hostConfig, RenderArgs renderArgs, TagContent tagContent) {
        boolean requiresSurroundingLayout;
        boolean mustStretch = element.GetHeight() == HeightType.Stretch;
        boolean inputHasLabel = !element.GetLabel().isEmpty();
        boolean inputHasErrorMessage = !element.GetErrorMessage().isEmpty();
        boolean bl = requiresSurroundingLayout = mustStretch || inputHasLabel || inputHasErrorMessage;
        if (requiresSurroundingLayout) {
            StretchableInputLayout inputLayout = new StretchableInputLayout(context, mustStretch);
            View actualInput = CardRendererRegistration.findElementWithTagContent(mockLayout);
            if (inputHasLabel) {
                TextView inputLabel = InputUtil.RenderInputLabel(element.GetLabel(), element.GetIsRequired(), context, hostConfig, renderArgs);
                inputLayout.setLabel(inputLabel);
                BaseCardElementRenderer.setSpacingAndSeparator(context, (ViewGroup)inputLayout, hostConfig.GetInputs().getLabel().getInputSpacing(), false, hostConfig, true);
            } else if (element.GetIsRequired()) {
                renderedCard.addWarning(new AdaptiveWarning(8, "Input is required but there's no label for required hint rendering"));
            }
            tagContent.SetStretchContainer((View)inputLayout);
            if (mockLayout.getChildCount() == 1) {
                View inputView = mockLayout.getChildAt(0);
                mockLayout.removeView(inputView);
                inputLayout.setInputView(inputView);
            } else {
                Util.MoveChildrenViews(mockLayout, (ViewGroup)inputLayout);
            }
            if (inputHasErrorMessage) {
                View spacing = BaseCardElementRenderer.setSpacingAndSeparator(context, (ViewGroup)inputLayout, hostConfig.GetInputs().getErrorMessage().getSpacing(), false, hostConfig, true);
                TextView errorMessage = InputUtil.RenderErrorMessage(element.GetErrorMessage(), context, hostConfig, renderArgs);
                errorMessage.setTag((Object)new TagContent(null, spacing, null));
                inputLayout.setErrorMessage(errorMessage);
                BaseCardElementRenderer.setVisibility(false, (View)errorMessage);
                IInputHandler inputHandler = tagContent.GetInputHandler();
                if (inputHandler instanceof BaseInputHandler) {
                    ((BaseInputHandler)inputHandler).setInputLayout(inputLayout);
                }
            }
            container.addView((View)inputLayout);
        } else {
            Util.MoveChildrenViews(mockLayout, container);
        }
    }

    private static void HandleStretchHeight(ViewGroup mockLayout, ViewGroup container, BaseCardElement element, Context context, TagContent tagContent) {
        boolean mustStretch;
        boolean bl = mustStretch = element.GetHeight() == HeightType.Stretch;
        if (mustStretch) {
            StretchableElementLayout stretchElementLayout = new StretchableElementLayout(context, mustStretch);
            Util.MoveChildrenViews(mockLayout, (ViewGroup)stretchElementLayout);
            container.addView((View)stretchElementLayout);
            tagContent.SetStretchContainer((View)stretchElementLayout);
        } else {
            Util.MoveChildrenViews(mockLayout, container);
        }
    }

    public static View findElementWithTagContent(ViewGroup viewContainer) {
        for (int i = 0; i < viewContainer.getChildCount(); ++i) {
            View childTaggedContent;
            View view = viewContainer.getChildAt(i);
            Object rawTag = view.getTag();
            if (rawTag != null && rawTag instanceof TagContent) {
                return view;
            }
            if (!(view instanceof ViewGroup) || (childTaggedContent = CardRendererRegistration.findElementWithTagContent((ViewGroup)view)) == null) continue;
            return childTaggedContent;
        }
        return null;
    }
}

