/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.objectmodel;

import io.adaptivecards.objectmodel.AdaptiveCardObjectModelJNI;
import io.adaptivecards.objectmodel.BaseCardElement;
import java.util.AbstractList;
import java.util.RandomAccess;

public class BaseCardElementVector
extends AbstractList<BaseCardElement>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected BaseCardElementVector(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(BaseCardElementVector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                AdaptiveCardObjectModelJNI.delete_BaseCardElementVector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public BaseCardElementVector(BaseCardElement[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (BaseCardElement element : initialElements) {
            this.add(element);
        }
    }

    public BaseCardElementVector(Iterable<BaseCardElement> initialElements) {
        this();
        for (BaseCardElement element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public BaseCardElement get(int index) {
        return this.doGet(index);
    }

    @Override
    public BaseCardElement set(int index, BaseCardElement e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(BaseCardElement e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, BaseCardElement e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public BaseCardElement remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public BaseCardElementVector() {
        this(AdaptiveCardObjectModelJNI.new_BaseCardElementVector__SWIG_0(), true);
    }

    public BaseCardElementVector(BaseCardElementVector other) {
        this(AdaptiveCardObjectModelJNI.new_BaseCardElementVector__SWIG_1(BaseCardElementVector.getCPtr(other), other), true);
    }

    public long capacity() {
        return AdaptiveCardObjectModelJNI.BaseCardElementVector_capacity(this.swigCPtr, this);
    }

    public void reserve(long n) {
        AdaptiveCardObjectModelJNI.BaseCardElementVector_reserve(this.swigCPtr, this, n);
    }

    @Override
    public boolean isEmpty() {
        return AdaptiveCardObjectModelJNI.BaseCardElementVector_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        AdaptiveCardObjectModelJNI.BaseCardElementVector_clear(this.swigCPtr, this);
    }

    public BaseCardElementVector(int count, BaseCardElement value) {
        this(AdaptiveCardObjectModelJNI.new_BaseCardElementVector__SWIG_2(count, BaseCardElement.getCPtr(value), value), true);
    }

    private int doSize() {
        return AdaptiveCardObjectModelJNI.BaseCardElementVector_doSize(this.swigCPtr, this);
    }

    private void doAdd(BaseCardElement x) {
        AdaptiveCardObjectModelJNI.BaseCardElementVector_doAdd__SWIG_0(this.swigCPtr, this, BaseCardElement.getCPtr(x), x);
    }

    private void doAdd(int index, BaseCardElement x) {
        AdaptiveCardObjectModelJNI.BaseCardElementVector_doAdd__SWIG_1(this.swigCPtr, this, index, BaseCardElement.getCPtr(x), x);
    }

    private BaseCardElement doRemove(int index) {
        long cPtr = AdaptiveCardObjectModelJNI.BaseCardElementVector_doRemove(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new BaseCardElement(cPtr, true);
    }

    private BaseCardElement doGet(int index) {
        long cPtr = AdaptiveCardObjectModelJNI.BaseCardElementVector_doGet(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new BaseCardElement(cPtr, true);
    }

    private BaseCardElement doSet(int index, BaseCardElement val) {
        long cPtr = AdaptiveCardObjectModelJNI.BaseCardElementVector_doSet(this.swigCPtr, this, index, BaseCardElement.getCPtr(val), val);
        return cPtr == 0L ? null : new BaseCardElement(cPtr, true);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        AdaptiveCardObjectModelJNI.BaseCardElementVector_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

