/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.input;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.ChoiceInput;
import io.adaptivecards.objectmodel.ChoiceInputVector;
import io.adaptivecards.objectmodel.ChoiceSetInput;
import io.adaptivecards.objectmodel.ChoiceSetStyle;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.inputhandler.CheckBoxSetInputHandler;
import io.adaptivecards.renderer.inputhandler.ComboBoxInputHandler;
import io.adaptivecards.renderer.inputhandler.RadioGroupInputHandler;
import io.adaptivecards.renderer.registration.CardRendererRegistration;
import java.util.Arrays;
import java.util.Vector;

public class ChoiceSetInputRenderer
extends BaseCardElementRenderer {
    private static ChoiceSetInputRenderer s_instance = null;

    protected ChoiceSetInputRenderer() {
    }

    public static ChoiceSetInputRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ChoiceSetInputRenderer();
        }
        return s_instance;
    }

    public View renderCheckBoxSet(RenderedAdaptiveCard renderedCard, Context context, ChoiceSetInput choiceSetInput, RenderArgs renderArgs) {
        LinearLayout layout2 = new LinearLayout(context);
        layout2.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        layout2.setOrientation(1);
        Vector<CheckBox> checkBoxList = new Vector<CheckBox>();
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        long size = choiceInputVector.size();
        String value = choiceSetInput.GetValue();
        Vector<String> defaults = new Vector<String>();
        defaults.addAll(Arrays.asList(value.split(",")));
        final CheckBoxSetInputHandler checkBoxSetInputHandler = new CheckBoxSetInputHandler(choiceSetInput, checkBoxList);
        checkBoxSetInputHandler.setView((View)layout2);
        layout2.setTag((Object)new TagContent((BaseCardElement)choiceSetInput, checkBoxSetInputHandler));
        int i = 0;
        while ((long)i < size) {
            ChoiceInput choiceInput = choiceInputVector.get(i);
            CheckBox checkBox = new CheckBox(context);
            checkBox.setText((CharSequence)choiceInput.GetTitle());
            if (!choiceSetInput.GetWrap()) {
                checkBox.setMaxLines(1);
                checkBox.setEllipsize(TextUtils.TruncateAt.END);
            }
            if (defaults.contains(choiceInput.GetValue())) {
                checkBox.setChecked(true);
            }
            checkBoxList.add(checkBox);
            checkBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    CardRendererRegistration.getInstance().notifyInputChange(checkBoxSetInputHandler.getId(), checkBoxSetInputHandler.getInput());
                }
            });
            checkBox.setOnTouchListener(new FocusableChoiceListener<CompoundButton>((CompoundButton)checkBoxList.get(0)));
            layout2.addView((View)checkBox);
            ++i;
        }
        renderedCard.registerInputHandler(checkBoxSetInputHandler, renderArgs.getContainerCardId());
        return layout2;
    }

    public View renderRadioGroup(RenderedAdaptiveCard renderedCard, Context context, ChoiceSetInput choiceSetInput, RenderArgs renderArgs) {
        RadioGroup radioGroup = new RadioGroup(context);
        final RadioGroupInputHandler radioGroupInputHandler = new RadioGroupInputHandler(choiceSetInput);
        radioGroupInputHandler.setView((View)radioGroup);
        radioGroup.setTag((Object)new TagContent((BaseCardElement)choiceSetInput, radioGroupInputHandler));
        radioGroup.setOrientation(1);
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        long size = choiceInputVector.size();
        String value = choiceSetInput.GetValue();
        int i = 0;
        while ((long)i < size) {
            ChoiceInput choiceInput = choiceInputVector.get(i);
            RadioButton radioButton = new RadioButton(context);
            radioButton.setId(i);
            if (!choiceSetInput.GetWrap()) {
                radioButton.setMaxLines(1);
                radioButton.setEllipsize(TextUtils.TruncateAt.END);
            }
            radioButton.setText((CharSequence)choiceInput.GetTitle());
            if (choiceInput.GetValue().equals(value)) {
                radioButton.setChecked(true);
            }
            radioGroup.addView((View)radioButton);
            radioButton.setOnTouchListener(new FocusableChoiceListener<RadioButton>((RadioButton)radioGroup.getChildAt(0)));
            ++i;
        }
        renderedCard.registerInputHandler(radioGroupInputHandler, renderArgs.getContainerCardId());
        radioGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup group, int checkedId) {
                CardRendererRegistration.getInstance().notifyInputChange(radioGroupInputHandler.getId(), radioGroupInputHandler.getInput());
            }
        });
        return radioGroup;
    }

    public View renderComboBox(RenderedAdaptiveCard renderedCard, Context context, ChoiceSetInput choiceSetInput, RenderArgs renderArgs) {
        Vector<String> titleList = new Vector<String>();
        ChoiceInputVector choiceInputVector = choiceSetInput.GetChoices();
        long size = choiceInputVector.size();
        int selection = 0;
        String value = choiceSetInput.GetValue();
        int i = 0;
        while ((long)i < size) {
            ChoiceInput choiceInput = choiceInputVector.get(i);
            titleList.addElement(choiceInput.GetTitle());
            if (choiceInput.GetValue().equals(value)) {
                selection = i;
            }
            ++i;
        }
        boolean hasEmptyDefault = value.isEmpty();
        if (hasEmptyDefault) {
            titleList.addElement(choiceSetInput.GetPlaceholder());
            selection = (int)size;
        }
        final ComboBoxInputHandler comboBoxInputHandler = new ComboBoxInputHandler(choiceSetInput);
        Spinner spinner = new Spinner(context);
        comboBoxInputHandler.setView((View)spinner);
        spinner.setTag((Object)new TagContent((BaseCardElement)choiceSetInput, comboBoxInputHandler));
        renderedCard.registerInputHandler(comboBoxInputHandler, renderArgs.getContainerCardId());
        class WrappedTextSpinnerAdapter
        extends TextSpinnerAdapter {
            WrappedTextSpinnerAdapter(Context context, int resource, Vector<String> items, boolean hasEmptyDefault) {
                class TextSpinnerAdapter
                extends ArrayAdapter<String> {
                    private int m_itemCount;
                    private boolean m_hasEmptyDefault;

                    TextSpinnerAdapter(Context context, int resource, Vector<String> items, boolean hasEmptyDefault) {
                        super(context, resource, items);
                        this.m_itemCount = 0;
                        this.m_hasEmptyDefault = false;
                        this.m_hasEmptyDefault = hasEmptyDefault;
                        this.m_itemCount = items.size();
                    }

                    public int getCount() {
                        if (this.m_hasEmptyDefault) {
                            return this.m_itemCount - 1;
                        }
                        return this.m_itemCount;
                    }
                }
                super(context, resource, items, hasEmptyDefault);
            }

            @NonNull
            public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
                View view = super.getView(position, convertView, parent);
                TextView txtView = (TextView)view.findViewById(16908308);
                txtView.setSingleLine(false);
                return view;
            }
        }
        TextSpinnerAdapter spinnerArrayAdapter = choiceSetInput.GetWrap() ? new WrappedTextSpinnerAdapter(context, 17367048, titleList, hasEmptyDefault) : new TextSpinnerAdapter(context, 17367048, titleList, hasEmptyDefault);
        spinnerArrayAdapter.setDropDownViewResource(0x1090009);
        spinner.setAdapter((SpinnerAdapter)spinnerArrayAdapter);
        spinner.setSelection(selection);
        spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                CardRendererRegistration.getInstance().notifyInputChange(comboBoxInputHandler.getId(), comboBoxInputHandler.getInput());
            }

            public void onNothingSelected(AdapterView<?> parent) {
                CardRendererRegistration.getInstance().notifyInputChange(comboBoxInputHandler.getId(), comboBoxInputHandler.getInput());
            }
        });
        spinner.setFocusable(true);
        return spinner;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) throws Exception {
        if (!hostConfig.GetSupportsInteractivity()) {
            renderedCard.addWarning(new AdaptiveWarning(3, "Input.ChoiceSet is not allowed"));
            return null;
        }
        ChoiceSetInput choiceSetInput = Util.castTo(baseCardElement, ChoiceSetInput.class);
        View inputView = null;
        if (choiceSetInput.GetIsMultiSelect()) {
            inputView = this.renderCheckBoxSet(renderedCard, context, choiceSetInput, renderArgs);
        } else if (choiceSetInput.GetChoiceSetStyle() == ChoiceSetStyle.Expanded) {
            inputView = this.renderRadioGroup(renderedCard, context, choiceSetInput, renderArgs);
        } else if (choiceSetInput.GetChoiceSetStyle() == ChoiceSetStyle.Compact) {
            inputView = this.renderComboBox(renderedCard, context, choiceSetInput, renderArgs);
        } else {
            throw new IllegalArgumentException("ChoiceSet Input, " + choiceSetInput.GetId() + ", contains invalid style, " + choiceSetInput.GetChoiceSetStyle().toString() + ".");
        }
        viewGroup.addView(inputView);
        return inputView;
    }

    public static class FocusableChoiceListener<T extends CompoundButton>
    implements View.OnTouchListener {
        private T m_firstView;

        public FocusableChoiceListener(T firstView) {
            this.m_firstView = firstView;
        }

        public boolean onTouch(View view, MotionEvent motionEvent) {
            if (motionEvent.getAction() == 1) {
                this.m_firstView.setFocusableInTouchMode(false);
                this.m_firstView.clearFocus();
                CompoundButton clickableElement = (CompoundButton)view;
                if (clickableElement instanceof CheckBox) {
                    clickableElement.setChecked(!clickableElement.isChecked());
                } else {
                    clickableElement.setChecked(true);
                }
            }
            return true;
        }
    }
}

