/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.graphics.Color;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import io.adaptivecards.objectmodel.AdaptiveCard;
import io.adaptivecards.objectmodel.BaseActionElementVector;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.HeightType;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.renderer.AdaptiveFallbackException;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.IActionLayoutRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.layout.StretchableElementLayout;
import io.adaptivecards.renderer.readonly.ContainerRenderer;
import io.adaptivecards.renderer.registration.CardRendererRegistration;

public class AdaptiveCardRenderer {
    public static final String VERSION = "1.3";
    private static AdaptiveCardRenderer s_instance = null;
    private HostConfig defaultHostConfig = new HostConfig();

    protected AdaptiveCardRenderer() {
    }

    public static AdaptiveCardRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new AdaptiveCardRenderer();
        }
        return s_instance;
    }

    public RenderedAdaptiveCard render(Context context, FragmentManager fragmentManager, AdaptiveCard adaptiveCard, ICardActionHandler cardActionHandler) {
        return this.render(context, fragmentManager, adaptiveCard, cardActionHandler, this.defaultHostConfig);
    }

    public RenderedAdaptiveCard render(Context context, FragmentManager fragmentManager, AdaptiveCard adaptiveCard, ICardActionHandler cardActionHandler, HostConfig hostConfig) {
        RenderedAdaptiveCard result = new RenderedAdaptiveCard(adaptiveCard);
        View cardView = this.internalRender(result, context, fragmentManager, adaptiveCard, cardActionHandler, hostConfig, false, -1L);
        result.setView(cardView);
        return result;
    }

    private ViewGroup renderCardElements(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, AdaptiveCard adaptiveCard, ICardActionHandler cardActionHandler, HostConfig hostConfig, ViewGroup cardLayout, RenderArgs renderArgs) {
        LinearLayout layout2 = new LinearLayout(context);
        layout2.setTag((Object)adaptiveCard);
        layout2.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        layout2.setOrientation(1);
        layout2.setClipChildren(false);
        layout2.setClipToPadding(false);
        ContainerRenderer.setVerticalContentAlignment((ViewGroup)layout2, adaptiveCard.GetVerticalContentAlignment());
        try {
            CardRendererRegistration.getInstance().renderElements(renderedCard, context, fragmentManager, cardLayout, adaptiveCard.GetBody(), cardActionHandler, hostConfig, renderArgs);
        }
        catch (AdaptiveFallbackException adaptiveFallbackException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return layout2;
    }

    public View internalRender(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, AdaptiveCard adaptiveCard, ICardActionHandler cardActionHandler, HostConfig hostConfig, boolean isInlineShowCard, long containerCardId) {
        if (hostConfig == null) {
            throw new IllegalArgumentException("hostConfig is null");
        }
        if (renderedCard == null) {
            throw new IllegalArgumentException("renderedCard is null");
        }
        LinearLayout rootLayout = new LinearLayout(context);
        rootLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        rootLayout.setOrientation(1);
        rootLayout.setClipChildren(false);
        rootLayout.setClipToPadding(false);
        long cardMinHeight = adaptiveCard.GetMinHeight();
        StretchableElementLayout cardLayout = new StretchableElementLayout(context, adaptiveCard.GetHeight() == HeightType.Stretch || cardMinHeight != 0L);
        cardLayout.setTag(adaptiveCard);
        cardLayout.setClipChildren(false);
        cardLayout.setClipToPadding(false);
        ContainerRenderer.setMinHeight(cardMinHeight, (View)rootLayout, context);
        ContainerRenderer.setVerticalContentAlignment((ViewGroup)cardLayout, adaptiveCard.GetVerticalContentAlignment());
        cardLayout.setOrientation(1);
        int padding = Util.dpToPixels(context, hostConfig.GetSpacing().getPaddingSpacing());
        cardLayout.setPadding(padding, padding, padding, padding);
        rootLayout.addView((View)cardLayout);
        ContainerStyle style2 = ContainerStyle.Default;
        if (isInlineShowCard && hostConfig.GetActions().getShowCard().getStyle() != ContainerStyle.None) {
            style2 = hostConfig.GetActions().getShowCard().getStyle();
        }
        if (hostConfig.GetAdaptiveCard().getAllowCustomStyle() && adaptiveCard.GetStyle() != ContainerStyle.None) {
            style2 = adaptiveCard.GetStyle();
        }
        RenderArgs renderArgs = new RenderArgs();
        renderArgs.setContainerStyle(style2);
        long cardId = Util.getViewId((View)rootLayout);
        renderArgs.setContainerCardId(cardId);
        renderedCard.setParentToCard(cardId, containerCardId);
        String color = hostConfig.GetBackgroundColor(style2);
        cardLayout.setBackgroundColor(Color.parseColor((String)color));
        cardLayout.addView((View)this.renderCardElements(renderedCard, context, fragmentManager, adaptiveCard, cardActionHandler, hostConfig, (ViewGroup)cardLayout, renderArgs));
        if (hostConfig.GetSupportsInteractivity()) {
            BaseActionElementVector baseActionElementList = adaptiveCard.GetActions();
            if (baseActionElementList != null && baseActionElementList.size() > 0) {
                LinearLayout showCardsLayout = new LinearLayout(context);
                showCardsLayout.setBackgroundColor(Color.parseColor((String)color));
                showCardsLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
                rootLayout.addView((View)showCardsLayout);
                IActionLayoutRenderer actionLayoutRenderer = CardRendererRegistration.getInstance().getActionLayoutRenderer();
                if (actionLayoutRenderer != null) {
                    try {
                        actionLayoutRenderer.renderActions(renderedCard, context, fragmentManager, (ViewGroup)cardLayout, baseActionElementList, cardActionHandler, hostConfig, renderArgs);
                    }
                    catch (AdaptiveFallbackException adaptiveFallbackException) {}
                }
            }
        } else {
            renderedCard.addWarning(new AdaptiveWarning(3, "Interactivity is not allowed. Actions not rendered."));
        }
        ContainerRenderer.setBackgroundImage(renderedCard, context, adaptiveCard.GetBackgroundImage(), hostConfig, (ViewGroup)cardLayout);
        ContainerRenderer.setSelectAction(renderedCard, renderedCard.getAdaptiveCard().GetSelectAction(), (View)rootLayout, cardActionHandler, renderArgs);
        return rootLayout;
    }
}

