/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.google.android.flexbox.FlexboxLayout;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.Column;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.VerticalContentAlignment;
import io.adaptivecards.renderer.AdaptiveFallbackException;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.layout.SelectableFlexboxLayout;
import io.adaptivecards.renderer.readonly.ContainerRenderer;
import io.adaptivecards.renderer.registration.CardRendererRegistration;
import java.util.Locale;

public class ColumnRenderer
extends BaseCardElementRenderer {
    private static ColumnRenderer s_instance = null;
    private final String g_columnSizeAuto = "auto";
    private final String g_columnSizeStretch = "stretch";

    protected ColumnRenderer() {
    }

    public static ColumnRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ColumnRenderer();
        }
        return s_instance;
    }

    private void setVerticalContentAlignment(VerticalContentAlignment verticalContentAlignment, ViewGroup linearLayout) {
        ViewGroup.LayoutParams layoutParams = linearLayout.getLayoutParams();
        int alignment = 0;
        int gravity = 48;
        switch (verticalContentAlignment) {
            case Center: {
                alignment = 2;
                gravity = 16;
                break;
            }
            case Bottom: {
                alignment = 1;
                gravity = 80;
                break;
            }
            default: {
                alignment = 0;
                gravity = 48;
            }
        }
        if (linearLayout instanceof FlexboxLayout) {
            ((FlexboxLayout)linearLayout).setAlignItems(alignment);
        } else if (linearLayout instanceof LinearLayout) {
            ((LinearLayout)linearLayout).setGravity(gravity);
        }
    }

    private boolean hasRatioWidth(Column column) {
        try {
            String columnSize = column.GetWidth().toLowerCase(Locale.getDefault());
            Float.parseFloat(columnSize);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private ViewGroup setColumnWidth(RenderedAdaptiveCard renderedCard, Context context, Column column, ViewGroup columnLayout) {
        String columnSize = column.GetWidth().toLowerCase(Locale.getDefault());
        long pixelWidth = column.GetPixelWidth();
        if (pixelWidth != 0L) {
            columnLayout.setLayoutParams((ViewGroup.LayoutParams)new FlexboxLayout.LayoutParams(Util.dpToPixels(context, pixelWidth), -1));
            return columnLayout;
        }
        if (this.hasRatioWidth(column)) {
            float columnWeight = Float.parseFloat(columnSize);
            FlexboxLayout.LayoutParams layoutParams = new FlexboxLayout.LayoutParams(0, -1);
            layoutParams.setFlexGrow(columnWeight);
            layoutParams.setFlexShrink(1.0f);
            columnLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            return columnLayout;
        }
        if (TextUtils.isEmpty((CharSequence)columnSize) || columnSize.equals("stretch")) {
            FlexboxLayout.LayoutParams layoutParams = new FlexboxLayout.LayoutParams(-2, -1);
            layoutParams.setFlexGrow(1.0f);
            layoutParams.setFlexShrink(1.0f);
            columnLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            return columnLayout;
        }
        FlexboxLayout.LayoutParams layoutParams = new FlexboxLayout.LayoutParams(-2, -1);
        layoutParams.setFlexGrow(0.0f);
        layoutParams.setFlexShrink(1.0f);
        columnLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (!columnSize.equals("auto")) {
            renderedCard.addWarning(new AdaptiveWarning(7, "Column Width (" + column.GetWidth() + ") is not a valid weight ('auto', 'stretch', <integer>)."));
        }
        return columnLayout;
    }

    @Override
    public View render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) throws Exception {
        Column column = Util.castTo(baseCardElement, Column.class);
        View separator = ColumnRenderer.setSpacingAndSeparator(context, viewGroup, column.GetSpacing(), column.GetSeparator(), hostConfig, false);
        SelectableFlexboxLayout columnLayout = new SelectableFlexboxLayout(context);
        columnLayout.setFlexDirection(2);
        columnLayout.setTag(new TagContent(column));
        ColumnRenderer.setVisibility(baseCardElement.GetIsVisible(), (View)columnLayout);
        ViewGroup itemsContainer = this.setColumnWidth(renderedCard, context, column, (ViewGroup)columnLayout);
        itemsContainer = ColumnRenderer.setMinHeight(column.GetMinHeight(), (FlexboxLayout)itemsContainer, context);
        ContainerStyle containerStyle = renderArgs.getContainerStyle();
        ContainerStyle styleForThis = ContainerRenderer.GetLocalContainerStyle(column, containerStyle);
        RenderArgs columnRenderArgs = new RenderArgs(renderArgs);
        columnRenderArgs.setContainerStyle(styleForThis);
        if (!column.GetItems().isEmpty()) {
            try {
                CardRendererRegistration.getInstance().renderElements(renderedCard, context, fragmentManager, itemsContainer, column.GetItems(), cardActionHandler, hostConfig, columnRenderArgs);
            }
            catch (AdaptiveFallbackException e) {
                viewGroup.removeView(separator);
                throw e;
            }
        }
        ContainerRenderer.setBackgroundImage(renderedCard, context, column.GetBackgroundImage(), hostConfig, (ViewGroup)columnLayout);
        this.setVerticalContentAlignment(column.GetVerticalContentAlignment(), itemsContainer);
        ContainerRenderer.ApplyPadding(styleForThis, renderArgs.getContainerStyle(), (ViewGroup)columnLayout, context, hostConfig);
        ContainerRenderer.ApplyBleed(column, (ViewGroup)columnLayout, context, hostConfig);
        ContainerRenderer.setSelectAction(renderedCard, column.GetSelectAction(), (View)columnLayout, cardActionHandler, renderArgs);
        viewGroup.addView((View)columnLayout);
        return columnLayout;
    }
}

