/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Shader;
import android.os.AsyncTask;
import android.support.constraint.ConstraintLayout;
import android.support.constraint.ConstraintSet;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import io.adaptivecards.R;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.HeightType;
import io.adaptivecards.objectmodel.HorizontalAlignment;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.Image;
import io.adaptivecards.objectmodel.ImageSize;
import io.adaptivecards.objectmodel.ImageSizesConfig;
import io.adaptivecards.objectmodel.ImageStyle;
import io.adaptivecards.renderer.BaseCardElementRenderer;
import io.adaptivecards.renderer.IOnlineImageLoader;
import io.adaptivecards.renderer.InnerImageLoaderAsync;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.TagContent;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;
import io.adaptivecards.renderer.layout.HorizontalFlowLayout;
import io.adaptivecards.renderer.readonly.ContainerRenderer;
import io.adaptivecards.renderer.registration.CardRendererRegistration;

public class ImageRenderer
extends BaseCardElementRenderer {
    private static ImageRenderer s_instance = null;

    protected ImageRenderer() {
    }

    public static ImageRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ImageRenderer();
        }
        return s_instance;
    }

    private static int getImageSizePixels(Context context, ImageSize imageSize, ImageSizesConfig imageSizesConfig) {
        int imageSizeLimit = context.getResources().getDisplayMetrics().widthPixels;
        if (imageSize == ImageSize.Small) {
            imageSizeLimit = Util.dpToPixels(context, imageSizesConfig.getSmallSize());
        } else if (imageSize == ImageSize.Medium) {
            imageSizeLimit = Util.dpToPixels(context, imageSizesConfig.getMediumSize());
        } else if (imageSize == ImageSize.Large) {
            imageSizeLimit = Util.dpToPixels(context, imageSizesConfig.getLargeSize());
        }
        return imageSizeLimit;
    }

    private static void sizeImageForImageSet(Context context, ImageView imageView, Image image, HostConfig hostConfig) {
        int semanticWidth = ImageRenderer.getImageSizePixels(context, image.GetImageSize(), hostConfig.GetImageSizes());
        imageView.setAdjustViewBounds(true);
        imageView.setScaleType(ImageView.ScaleType.FIT_START);
        imageView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(semanticWidth, -2));
    }

    private static float getHorizontalBias(Image image) {
        if (image.GetHorizontalAlignment() == HorizontalAlignment.Center) {
            return 0.5f;
        }
        if (image.GetHorizontalAlignment() == HorizontalAlignment.Right) {
            return 1.0f;
        }
        return 0.0f;
    }

    private static ConstraintLayout createContainer(Context context, Image image) {
        ConstraintLayout container = (ConstraintLayout)LayoutInflater.from((Context)context).inflate(R.layout.image_constraint_layout, null);
        if (image.GetHeight() == HeightType.Stretch) {
            container.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        } else {
            container.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        }
        return container;
    }

    private static ConstraintSet createConstraints(Context context, ImageView imageView, Image image, HostConfig hostConfig) {
        long explicitWidth = image.GetPixelWidth();
        long explicitHeight = image.GetPixelHeight();
        ImageSize imageSize = image.GetImageSize();
        ConstraintSet constraints = new ConstraintSet();
        if (imageView.getId() == -1) {
            imageView.setId(View.generateViewId());
        }
        int id2 = imageView.getId();
        constraints.clone(context, R.layout.image_constraint_layout);
        constraints.constrainWidth(id2, 0);
        constraints.constrainDefaultWidth(id2, 1);
        constraints.connect(id2, 6, R.id.leftBarrier, 6);
        constraints.connect(id2, 7, R.id.rightBarrier, 7);
        imageView.setAdjustViewBounds(true);
        imageView.setScaleType(ImageView.ScaleType.FIT_START);
        constraints.constrainHeight(id2, -2);
        constraints.connect(id2, 3, 0, 3);
        constraints.setHorizontalBias(R.id.widthPlaceholder, ImageRenderer.getHorizontalBias(image));
        constraints.setHorizontalBias(id2, ImageRenderer.getHorizontalBias(image));
        if (explicitWidth != 0L || explicitHeight != 0L) {
            if (explicitWidth != 0L && explicitHeight != 0L) {
                imageView.setScaleType(ImageView.ScaleType.FIT_XY);
            }
            if (explicitWidth != 0L) {
                constraints.constrainWidth(R.id.widthPlaceholder, Util.dpToPixels(context, explicitWidth));
                constraints.constrainDefaultWidth(id2, 0);
            }
            if (explicitHeight != 0L) {
                constraints.constrainHeight(id2, Util.dpToPixels(context, explicitHeight));
            }
        } else if (imageSize == ImageSize.Small || imageSize == ImageSize.Medium || imageSize == ImageSize.Large) {
            constraints.constrainWidth(R.id.widthPlaceholder, ImageRenderer.getImageSizePixels(context, imageSize, hostConfig.GetImageSizes()));
            constraints.constrainDefaultWidth(id2, 0);
        } else if (imageSize == ImageSize.Stretch) {
            constraints.constrainDefaultWidth(id2, 0);
        }
        return constraints;
    }

    private int getBackgroundColorFromHexCode(String hexColorCode) {
        int backgroundColor = 0;
        if (!TextUtils.isEmpty((CharSequence)hexColorCode)) {
            if (hexColorCode.length() == 9 && hexColorCode.charAt(0) == '#') {
                try {
                    backgroundColor = Color.parseColor((String)hexColorCode);
                }
                catch (IllegalArgumentException e) {
                    backgroundColor = 0;
                }
            } else {
                backgroundColor = 0;
            }
        }
        return backgroundColor;
    }

    public ImageView render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseCardElement baseCardElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) throws Exception {
        Image image = Util.castTo(baseCardElement, Image.class);
        View separator = null;
        boolean isInImageSet = viewGroup instanceof HorizontalFlowLayout;
        if (isInImageSet) {
            separator = ImageRenderer.setSpacingAndSeparator(context, viewGroup, image.GetSpacing(), image.GetSeparator(), hostConfig, false, isInImageSet);
        }
        ImageView imageView = new ImageView(context);
        imageView.setContentDescription((CharSequence)image.GetAltText());
        int backgroundColor = this.getBackgroundColorFromHexCode(image.GetBackgroundColor());
        if (image.GetImageStyle() != ImageStyle.Person) {
            imageView.setBackgroundColor(backgroundColor);
        }
        int imageSizeLimit = ImageRenderer.getImageSizePixels(context, image.GetImageSize(), hostConfig.GetImageSizes());
        ImageRendererImageLoaderAsync imageLoaderAsync = new ImageRendererImageLoaderAsync(renderedCard, imageView, hostConfig.GetImageBaseUrl(), image.GetImageStyle(), backgroundColor, imageSizeLimit);
        IOnlineImageLoader onlineImageLoader = CardRendererRegistration.getInstance().getOnlineImageLoader();
        if (onlineImageLoader != null) {
            imageLoaderAsync.registerCustomOnlineImageLoader(onlineImageLoader);
        }
        imageLoaderAsync.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[]{image.GetUrl()});
        TagContent tagContent = new TagContent(image, separator, viewGroup);
        if (isInImageSet) {
            ImageRenderer.sizeImageForImageSet(context, imageView, image, hostConfig);
            viewGroup.addView((View)imageView);
        } else {
            ConstraintLayout container = ImageRenderer.createContainer(context, image);
            tagContent.SetStretchContainer((View)container);
            container.addView((View)imageView);
            ImageRenderer.createConstraints(context, imageView, image, hostConfig).applyTo(container);
            viewGroup.addView((View)container);
        }
        imageView.setTag((Object)tagContent);
        ImageRenderer.setVisibility(baseCardElement.GetIsVisible(), (View)imageView);
        ContainerRenderer.setSelectAction(renderedCard, image.GetSelectAction(), (View)imageView, cardActionHandler, renderArgs);
        return imageView;
    }

    private class ImageRendererImageLoaderAsync
    extends InnerImageLoaderAsync {
        private ImageStyle m_imageStyle;
        private int m_backgroundColor;

        ImageRendererImageLoaderAsync(RenderedAdaptiveCard renderedCard, ImageView imageView, String imageBaseUrl, ImageStyle imageStyle, int backgroundColor) {
            this(renderedCard, imageView, imageBaseUrl, imageStyle, backgroundColor, -1);
        }

        ImageRendererImageLoaderAsync(RenderedAdaptiveCard renderedCard, ImageView imageView, String imageBaseUrl, ImageStyle imageStyle, int backgroundColor, int maxWidth) {
            super(renderedCard, (View)imageView, imageBaseUrl, maxWidth);
            this.m_imageStyle = imageStyle;
            this.m_backgroundColor = backgroundColor;
        }

        @Override
        public Bitmap styleBitmap(Bitmap bitmap) {
            if (bitmap != null && this.m_imageStyle == ImageStyle.Person) {
                Bitmap circleBitmap = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                BitmapShader shader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
                Paint paint = new Paint();
                paint.setShader((Shader)shader);
                Paint backgroundColorPaint = new Paint();
                backgroundColorPaint.setColor(this.m_backgroundColor);
                Canvas c = new Canvas(circleBitmap);
                c.drawCircle((float)(bitmap.getWidth() / 2), (float)(bitmap.getHeight() / 2), (float)(bitmap.getWidth() / 2), backgroundColorPaint);
                c.drawCircle((float)(bitmap.getWidth() / 2), (float)(bitmap.getHeight() / 2), (float)(bitmap.getWidth() / 2), paint);
                bitmap = circleBitmap;
            }
            return bitmap;
        }

        @Override
        protected void renderBitmap(Bitmap bitmap) {
            ImageView view = (ImageView)this.m_view;
            view.setImageBitmap(bitmap);
        }
    }
}

