/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.AsyncTask;
import io.adaptivecards.objectmodel.AdaptiveBase64Util;
import io.adaptivecards.objectmodel.CharVector;
import io.adaptivecards.renderer.AdaptiveWarning;
import io.adaptivecards.renderer.IOnlineImageLoader;
import io.adaptivecards.renderer.IResourceResolver;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.http.HttpRequestHelper;
import io.adaptivecards.renderer.http.HttpRequestResult;
import io.adaptivecards.renderer.registration.CardRendererRegistration;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public abstract class GenericImageLoaderAsync
extends AsyncTask<String, Void, HttpRequestResult<Bitmap>> {
    RenderedAdaptiveCard m_renderedCard;
    String m_imageBaseUrl;
    int m_maxWidth;
    IOnlineImageLoader m_onlineImageLoader = null;

    GenericImageLoaderAsync(RenderedAdaptiveCard renderedCard, String imageBaseUrl) {
        this(renderedCard, imageBaseUrl, -1);
    }

    GenericImageLoaderAsync(RenderedAdaptiveCard renderedCard, String imageBaseUrl, int maxWidth) {
        this.m_renderedCard = renderedCard;
        this.m_imageBaseUrl = imageBaseUrl;
        this.m_maxWidth = maxWidth;
    }

    protected String getUriScheme(String path) throws URISyntaxException {
        try {
            URI uri = new URI(path);
            return uri.getScheme();
        }
        catch (URISyntaxException uriSyntaxException) {
            int schemeEndIndex = path.indexOf(58);
            if (schemeEndIndex > 0) {
                return path.substring(0, schemeEndIndex);
            }
            throw uriSyntaxException;
        }
    }

    HttpRequestResult<Bitmap> loadImage(String path, Context context) {
        try {
            String uriScheme = this.getUriScheme(path);
            IResourceResolver resourceResolver = CardRendererRegistration.getInstance().getResourceResolver(uriScheme);
            if (resourceResolver != null) {
                if (this.m_maxWidth != -1) {
                    return resourceResolver.resolveImageResource(path, this, this.m_maxWidth);
                }
                return resourceResolver.resolveImageResource(path, this);
            }
            if (path.startsWith("content:")) {
                return this.loadLocalContentImage(context, path);
            }
            if (uriScheme.equals("data")) {
                return this.loadDataUriImage(path);
            }
            try {
                if (this.m_onlineImageLoader != null) {
                    HttpRequestResult<Bitmap> loadedOnlineImage = this.m_onlineImageLoader.loadOnlineImage(path, this);
                    if (loadedOnlineImage.getResult() != null) {
                        return new HttpRequestResult<Bitmap>(this.styleBitmap(loadedOnlineImage.getResult()));
                    }
                    return loadedOnlineImage;
                }
                return this.loadOnlineImage(path);
            }
            catch (MalformedURLException e1) {
                try {
                    if (this.m_imageBaseUrl == null || this.m_imageBaseUrl.isEmpty()) {
                        throw new IOException("Image base URL is empty or not specified");
                    }
                    URL urlContext = new URL(this.m_imageBaseUrl);
                    URL url = new URL(urlContext, path);
                    if (this.m_onlineImageLoader != null) {
                        HttpRequestResult<Bitmap> loadedOnlineImage = this.m_onlineImageLoader.loadOnlineImage(url.toString(), this);
                        if (loadedOnlineImage.getResult() != null) {
                            return new HttpRequestResult<Bitmap>(this.styleBitmap(loadedOnlineImage.getResult()));
                        }
                        return loadedOnlineImage;
                    }
                    return this.loadOnlineImage(url.toString());
                }
                catch (MalformedURLException e2) {
                    return this.loadLocalImage(this.m_imageBaseUrl, context, path);
                }
            }
        }
        catch (Exception e) {
            return new HttpRequestResult<Bitmap>(e);
        }
    }

    public HttpRequestResult<Bitmap> loadOnlineImage(String url) throws IOException, URISyntaxException {
        byte[] bytes = HttpRequestHelper.get(url);
        if (bytes == null) {
            throw new IOException("Failed to retrieve content from " + url);
        }
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
        if ((bitmap = this.styleBitmap(bitmap)) == null) {
            throw new IOException("Failed to convert content to bitmap: " + new String(bytes));
        }
        return new HttpRequestResult<Bitmap>(bitmap);
    }

    public HttpRequestResult<Bitmap> loadLocalImage(String imageBaseUrl, Context context, String url) throws IOException {
        String authority = context.getPackageName();
        Resources resources = context.getResources();
        int identifier = resources.getIdentifier(url, imageBaseUrl, authority);
        if (identifier == 0) {
            throw new IOException("Image not found: " + url);
        }
        InputStream ins = resources.openRawResource(identifier);
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)ins);
        if ((bitmap = this.styleBitmap(bitmap)) == null) {
            throw new IOException("Failed to convert local content to bitmap: " + url);
        }
        return new HttpRequestResult<Bitmap>(bitmap);
    }

    private HttpRequestResult<Bitmap> loadLocalContentImage(Context context, String url) throws IOException {
        Uri uri = Uri.parse((String)url);
        Bitmap bm = BitmapFactory.decodeStream((InputStream)context.getContentResolver().openInputStream(uri));
        if ((bm = this.styleBitmap(bm)) == null) {
            throw new IOException("Failed to convert local content image to bitmap: " + url);
        }
        return new HttpRequestResult<Bitmap>(bm);
    }

    public HttpRequestResult<Bitmap> loadDataUriImage(String uri) throws Exception {
        String dataUri = AdaptiveBase64Util.ExtractDataFromUri(uri);
        CharVector decodedDataUri = AdaptiveBase64Util.Decode(dataUri);
        byte[] decodedByteArray = Util.getBytes(decodedDataUri);
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])decodedByteArray, (int)0, (int)decodedByteArray.length);
        bitmap = this.styleBitmap(bitmap);
        return new HttpRequestResult<Bitmap>(bitmap);
    }

    @Deprecated
    public void registerCustomOnlineImageLoader(IOnlineImageLoader onlineImageLoader) {
        this.m_onlineImageLoader = onlineImageLoader;
    }

    public Bitmap styleBitmap(Bitmap bitmap) {
        return bitmap;
    }

    protected void onPostExecute(HttpRequestResult<Bitmap> result) {
        if (result.isSuccessful()) {
            Bitmap image = result.getResult();
            if (image != null) {
                image.setDensity(160);
            }
            this.onSuccessfulPostExecute(image);
        } else {
            this.m_renderedCard.addWarning(new AdaptiveWarning(2, result.getException().getMessage()));
        }
    }

    abstract void onSuccessfulPostExecute(Bitmap var1);
}

