/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.layout;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

public class HorizontalFlowLayout
extends RelativeLayout {
    public HorizontalFlowLayout(Context context) {
        super(context);
    }

    public HorizontalFlowLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public HorizontalFlowLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int requiredHeight = this.measureRequiredHeight(width, this.getPaddingTop(), this.getPaddingBottom(), this.getPaddingLeft(), this.getPaddingRight());
        if (View.MeasureSpec.getMode((int)heightMeasureSpec) == 0) {
            height = requiredHeight;
        } else if (View.MeasureSpec.getMode((int)heightMeasureSpec) == Integer.MIN_VALUE && requiredHeight < height) {
            height = requiredHeight;
        }
        this.setMeasuredDimension(width, height);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int xpos = this.getPaddingLeft();
        int ypos = this.getPaddingTop();
        int line_height = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            int childMarginBottom;
            int childMarginTop;
            int childMarginRight;
            int childMarginLeft;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            if (child.getLayoutParams() != null && child.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams childMarginLayoutParams = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
                childMarginLeft = childMarginLayoutParams.leftMargin;
                childMarginRight = childMarginLayoutParams.rightMargin;
                childMarginTop = childMarginLayoutParams.topMargin;
                childMarginBottom = childMarginLayoutParams.bottomMargin;
            } else {
                childMarginLeft = 0;
                childMarginRight = 0;
                childMarginTop = 0;
                childMarginBottom = 0;
            }
            if (xpos + childMarginLeft + childWidth + childMarginRight + this.getPaddingRight() > r - l) {
                xpos = this.getPaddingLeft();
                ypos += line_height;
                line_height = childHeight + childMarginTop + childMarginBottom;
            } else {
                line_height = Math.max(line_height, childMarginTop + childHeight + childMarginBottom);
            }
            child.layout(xpos + childMarginLeft, ypos + childMarginTop, xpos + childMarginLeft + childWidth, ypos + childMarginTop + childHeight);
            xpos += childMarginLeft + childWidth + childMarginRight;
        }
    }

    int measureRequiredHeight(int width, int paddingTop, int paddingBottom, int paddingLeft, int paddingRight) {
        int xpos = paddingLeft;
        int ypos = paddingTop;
        int line_height = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            int childMarginBottom;
            int childMarginTop;
            int childMarginRight;
            int childMarginLeft;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            if (child.getLayoutParams() != null && child.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams childMarginLayoutParams = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
                childMarginLeft = childMarginLayoutParams.leftMargin;
                childMarginRight = childMarginLayoutParams.rightMargin;
                childMarginTop = childMarginLayoutParams.topMargin;
                childMarginBottom = childMarginLayoutParams.bottomMargin;
            } else {
                childMarginLeft = 0;
                childMarginRight = 0;
                childMarginTop = 0;
                childMarginBottom = 0;
            }
            if (xpos + childMarginLeft + childWidth + childMarginRight + paddingRight > width) {
                xpos = paddingLeft;
                ypos += line_height;
                line_height = childMarginTop + childHeight + childMarginBottom;
            } else {
                line_height = Math.max(line_height, childMarginTop + childHeight + childMarginBottom);
            }
            xpos += childMarginLeft + childWidth + childMarginRight;
        }
        return ypos += line_height + paddingBottom;
    }
}

