/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import io.adaptivecards.objectmodel.BaseActionElement;
import io.adaptivecards.objectmodel.BaseCardElement;
import io.adaptivecards.objectmodel.BaseElement;
import io.adaptivecards.objectmodel.BaseInputElement;
import io.adaptivecards.objectmodel.CharVector;
import io.adaptivecards.objectmodel.JsonValue;
import io.adaptivecards.objectmodel.ParseContext;
import java.lang.reflect.Method;

public final class Util {
    public static int dpToPixels(Context context, float dp) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        int returnVal = (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)metrics);
        return returnVal;
    }

    public static byte[] getBytes(CharVector charVector) {
        long vectorSize = charVector.size();
        byte[] byteArray = new byte[(int)vectorSize];
        int i = 0;
        while ((long)i < vectorSize) {
            byteArray[i] = (byte)charVector.get(i).charValue();
            ++i;
        }
        return byteArray;
    }

    public static void forceFocus(View v) {
        boolean focusableInTouchMode = v.isFocusableInTouchMode();
        v.setFocusable(true);
        v.setFocusableInTouchMode(true);
        v.requestFocusFromTouch();
        v.setFocusableInTouchMode(focusableInTouchMode);
    }

    public static Bitmap scaleBitmapToHeight(float height, Bitmap bitmap) {
        BitmapDrawable d = new BitmapDrawable(null, bitmap);
        float scaleRatio = height / (float)d.getIntrinsicHeight();
        float width = scaleRatio * (float)d.getIntrinsicWidth();
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)width), (int)((int)height), (boolean)false);
    }

    public static void MoveChildrenViews(ViewGroup origin, ViewGroup destination) {
        int childCount = origin.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View v = origin.getChildAt(i);
            origin.removeView(v);
            destination.addView(v);
        }
    }

    public static BaseCardElement tryCastToBaseCardElement(BaseElement baseElement) {
        try {
            return Util.castToBaseCardElement(baseElement);
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    public static BaseCardElement castToBaseCardElement(BaseElement baseElement) throws ClassCastException {
        BaseCardElement baseCardElement;
        if (baseElement instanceof BaseCardElement) {
            baseCardElement = (BaseCardElement)baseElement;
        } else {
            baseCardElement = BaseCardElement.dynamic_cast(baseElement);
            if (baseCardElement == null) {
                throw new ClassCastException("Unable to convert BaseElement to BaseCardElement object model.");
            }
        }
        return baseCardElement;
    }

    public static <T extends BaseCardElement> boolean isOfType(BaseCardElement cardElement, Class<T> cardElementType) {
        return Util.tryCastTo(cardElement, cardElementType) != null;
    }

    public static <T extends BaseCardElement> T tryCastTo(BaseCardElement cardElement, Class<T> cardElementType) {
        try {
            return Util.castTo(cardElement, cardElementType);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T extends BaseCardElement> T castTo(BaseCardElement cardElement, Class<T> cardElementType) throws ClassCastException {
        try {
            BaseCardElement castedElement = null;
            if (cardElementType.isAssignableFrom(cardElement.getClass())) {
                castedElement = cardElement;
            } else {
                Method dynamicCastMethod = cardElementType.getMethod("dynamic_cast", BaseCardElement.class);
                castedElement = (BaseCardElement)dynamicCastMethod.invoke(null, cardElement);
                if (castedElement == null) {
                    throw new InternalError("Unable to convert " + cardElement.getClass().getName() + " to " + cardElementType.getName() + " object model.");
                }
            }
            return (T)castedElement;
        }
        catch (Exception e) {
            throw new ClassCastException("Unable to find dynamic_cast method in " + cardElementType.getName() + ".");
        }
    }

    public static BaseActionElement tryCastToBaseActionElement(BaseElement baseElement) {
        try {
            return Util.castToBaseActionElement(baseElement);
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    public static BaseActionElement castToBaseActionElement(BaseElement baseElement) throws ClassCastException {
        BaseActionElement baseActionElement;
        if (baseElement instanceof BaseActionElement) {
            baseActionElement = (BaseActionElement)baseElement;
        } else {
            baseActionElement = BaseActionElement.dynamic_cast(baseElement);
            if (baseActionElement == null) {
                throw new ClassCastException("Unable to convert BaseElement to BaseCardElement object model.");
            }
        }
        return baseActionElement;
    }

    public static <T extends BaseActionElement> boolean isOfType(BaseActionElement actionElement, Class<T> actionElementType) {
        return Util.tryCastTo(actionElement, actionElementType) != null;
    }

    public static <T extends BaseActionElement> T tryCastTo(BaseActionElement actionElement, Class<T> actionElementType) {
        try {
            return Util.castTo(actionElement, actionElementType);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T extends BaseActionElement> T castTo(BaseActionElement actionElement, Class<T> actionElementType) throws ClassCastException {
        try {
            BaseActionElement castedElement = null;
            if (actionElementType.isAssignableFrom(actionElement.getClass())) {
                castedElement = actionElement;
            } else {
                Method dynamicCastMethod = actionElementType.getMethod("dynamic_cast", BaseActionElement.class);
                castedElement = (BaseActionElement)dynamicCastMethod.invoke(null, actionElement);
                if (castedElement == null) {
                    throw new InternalError("Unable to convert " + actionElement.getClass().getName() + " to " + actionElementType.getName() + " object model.");
                }
            }
            return (T)castedElement;
        }
        catch (Exception e) {
            throw new ClassCastException("Unable to find dynamic_cast method in " + actionElementType.getName() + ".");
        }
    }

    private static void CopyActionProperties(BaseActionElement origin, BaseActionElement dest) {
        dest.SetId(origin.GetId());
        dest.SetIconUrl(origin.GetIconUrl());
        dest.SetStyle(origin.GetStyle());
        dest.SetTitle(origin.GetTitle());
        dest.SetFallbackContent(origin.GetFallbackContent());
        dest.SetFallbackType(origin.GetFallbackType());
    }

    public static void deserializeBaseActionProperties(ParseContext context, JsonValue value, BaseActionElement actionElement) {
        BaseActionElement baseActionElement = BaseActionElement.DeserializeBaseProperties(context, value);
        Util.CopyActionProperties(baseActionElement, actionElement);
    }

    public static void deserializeBaseActionPropertiesFromString(ParseContext context, String jsonString, BaseActionElement actionElement) {
        BaseActionElement baseActionElement = BaseActionElement.DeserializeBasePropertiesFromString(context, jsonString);
        Util.CopyActionProperties(baseActionElement, actionElement);
    }

    private static void CopyCardElementProperties(BaseCardElement origin, BaseCardElement dest) {
        dest.SetId(origin.GetId());
        dest.SetHeight(origin.GetHeight());
        dest.SetIsVisible(origin.GetIsVisible());
        dest.SetSeparator(origin.GetSeparator());
        dest.SetSpacing(origin.GetSpacing());
        dest.SetFallbackContent(origin.GetFallbackContent());
        dest.SetFallbackType(origin.GetFallbackType());
    }

    public static void deserializeBaseCardElementProperties(ParseContext context, JsonValue value, BaseCardElement cardElement) {
        BaseCardElement baseCardElement = BaseCardElement.DeserializeBaseProperties(context, value);
        Util.CopyCardElementProperties(baseCardElement, cardElement);
    }

    public static void deserializeBaseCardElementPropertiesFromString(ParseContext context, String jsonString, BaseCardElement cardElement) {
        BaseCardElement baseCardElement = BaseCardElement.DeserializeBasePropertiesFromString(context, jsonString);
        Util.CopyCardElementProperties(baseCardElement, cardElement);
    }

    private static void CopyInputProperties(BaseInputElement origin, BaseInputElement dest) {
        Util.CopyCardElementProperties(origin, dest);
        dest.SetIsRequired(origin.GetIsRequired());
        dest.SetErrorMessage(origin.GetErrorMessage());
        dest.SetLabel(origin.GetLabel());
    }

    public static void deserializeBaseInputProperties(ParseContext context, JsonValue value, BaseInputElement inputElement) {
        BaseInputElement baseInputElement = BaseInputElement.DeserializeBaseProperties(context, value);
        Util.CopyInputProperties(baseInputElement, inputElement);
    }

    public static void deserializeBaseInputPropertiesFromString(ParseContext context, String jsonString, BaseInputElement inputElement) {
        BaseInputElement baseInputElement = BaseInputElement.DeserializeBasePropertiesFromString(context, jsonString);
        Util.CopyInputProperties(baseInputElement, inputElement);
    }

    public static long getViewId(View view) {
        if (view.getId() == -1) {
            view.setId(View.generateViewId());
        }
        return view.getId();
    }
}

