/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.input.customcontrols;

import android.content.Context;
import android.graphics.PorterDuff;
import android.support.v4.content.ContextCompat;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import io.adaptivecards.R;
import io.adaptivecards.renderer.input.customcontrols.IValidatedInputView;

public class ValidatedInputLayout
extends LinearLayout
implements IValidatedInputView {
    private boolean m_isInvalid = false;
    private int m_errorColor = 0;
    private static final int[] STATE_INPUT_INVALID = new int[]{R.attr.state_error};

    private ValidatedInputLayout(Context context) {
        super(context);
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.setOrientation(1);
        this.m_isInvalid = false;
    }

    public ValidatedInputLayout(Context context, int drawableId, int errorColor) {
        this(context);
        this.setBackground(ContextCompat.getDrawable((Context)context, (int)drawableId));
        this.m_errorColor = errorColor;
    }

    @Override
    public void setValidationResult(boolean isValid) {
        this.setInputInvalid(!isValid);
        if (!isValid) {
            this.getBackground().setColorFilter(this.m_errorColor, PorterDuff.Mode.SRC_ATOP);
        }
        this.invalidate();
    }

    public void setInputInvalid(boolean isInvalid) {
        this.m_isInvalid = isInvalid;
        this.refreshDrawableState();
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.m_isInvalid) {
            ValidatedInputLayout.mergeDrawableStates((int[])drawableState, (int[])STATE_INPUT_INVALID);
        }
        return drawableState;
    }
}

