/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.os.Build;
import android.text.Editable;
import android.text.Html;
import android.text.Spanned;
import io.adaptivecards.objectmodel.DateTimePreparser;
import io.adaptivecards.objectmodel.MarkDownParser;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.xml.sax.XMLReader;

public class RendererUtil {
    public static boolean isValidDate(String s) {
        long[] year = new long[]{0L};
        long[] month = new long[]{0L};
        long[] day = new long[]{0L};
        return DateTimePreparser.TryParseSimpleDate(s, year, month, day);
    }

    public static Calendar getDate(String s) {
        GregorianCalendar calendar = new GregorianCalendar();
        long[] year = new long[]{0L};
        long[] month = new long[]{0L};
        long[] day = new long[]{0L};
        if (DateTimePreparser.TryParseSimpleDate(s, year, month, day)) {
            calendar.set((int)year[0], (int)month[0] - 1, (int)day[0]);
        }
        return calendar;
    }

    public static boolean isValidTime(String s) {
        long[] hour = new long[]{0L};
        long[] minutes = new long[]{0L};
        return DateTimePreparser.TryParseSimpleTime(s, hour, minutes);
    }

    public static Calendar getTime(String s) {
        GregorianCalendar calendar = new GregorianCalendar();
        long[] hour = new long[]{0L};
        long[] minutes = new long[]{0L};
        if (DateTimePreparser.TryParseSimpleTime(s, hour, minutes)) {
            calendar.set(11, (int)hour[0]);
            calendar.set(12, (int)minutes[0]);
            calendar.set(13, 0);
        }
        return calendar;
    }

    public static CharSequence handleSpecialText(String textWithFormattedDates) {
        MarkDownParser markDownParser = new MarkDownParser(textWithFormattedDates);
        String textString = markDownParser.TransformToHtml();
        textString = textString.replace("<li>", "<listItem>");
        textString = textString.replaceAll("(" + System.lineSeparator() + "|\r\n|\n\r|\r|\n)", "<br/>");
        Spanned htmlString = Build.VERSION.SDK_INT >= 24 ? Html.fromHtml((String)textString, (int)63, null, (Html.TagHandler)new UlTagHandler()) : Html.fromHtml((String)textString, null, (Html.TagHandler)new UlTagHandler());
        return RendererUtil.trimHtmlString(htmlString);
    }

    public static CharSequence trimHtmlString(Spanned htmlString) {
        int i;
        int numToRemoveFromEnd = 0;
        int numToRemoveFromStart = 0;
        for (i = htmlString.length() - 1; i >= 0 && htmlString.charAt(i) == '\n'; --i) {
            ++numToRemoveFromEnd;
        }
        for (i = 0; i <= htmlString.length() - 1 && htmlString.charAt(i) == '\n'; ++i) {
            ++numToRemoveFromStart;
        }
        if (numToRemoveFromStart + numToRemoveFromEnd >= htmlString.length()) {
            return htmlString;
        }
        return htmlString.subSequence(numToRemoveFromStart, htmlString.length() - numToRemoveFromEnd);
    }

    public static class UlTagHandler
    implements Html.TagHandler {
        private int tagNumber = 0;
        private boolean orderedList = false;

        public void handleTag(boolean opening, String tag, Editable output, XMLReader xmlReader) {
            if (tag.equals("ul") && !opening) {
                output.append((CharSequence)"\n");
            }
            if (tag.equals("listItem") && opening) {
                if (this.orderedList) {
                    output.append((CharSequence)"\n");
                    output.append((CharSequence)String.valueOf(this.tagNumber));
                    output.append((CharSequence)". ");
                    ++this.tagNumber;
                } else {
                    output.append((CharSequence)"\n\u2022 ");
                }
            }
            if (tag.equals("ol") && opening) {
                this.orderedList = true;
                this.tagNumber = 1;
            }
        }
    }
}

