/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.action;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.os.AsyncTask;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import androidx.fragment.app.FragmentManager;
import io.adaptivecards.R;
import io.adaptivecards.objectmodel.ActionAlignment;
import io.adaptivecards.objectmodel.ActionType;
import io.adaptivecards.objectmodel.ActionsOrientation;
import io.adaptivecards.objectmodel.BaseActionElement;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.ExecuteAction;
import io.adaptivecards.objectmodel.ForegroundColor;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.IconPlacement;
import io.adaptivecards.objectmodel.SubmitAction;
import io.adaptivecards.renderer.BaseActionElementRenderer;
import io.adaptivecards.renderer.RenderArgs;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import io.adaptivecards.renderer.action.ActionElementRendererIconImageLoaderAsync;
import io.adaptivecards.renderer.actionhandler.ICardActionHandler;

public class ActionElementRenderer
extends BaseActionElementRenderer {
    private static ActionElementRenderer s_instance = null;

    protected ActionElementRenderer() {
    }

    public static ActionElementRenderer getInstance() {
        if (s_instance == null) {
            s_instance = new ActionElementRenderer();
        }
        return s_instance;
    }

    private static Button createButtonWithTheme(Context context, int theme) {
        ContextThemeWrapper themedContext = new ContextThemeWrapper(context, theme);
        return new Button((Context)themedContext);
    }

    protected static Button getButtonForStyle(Context context, String style2, HostConfig hostConfig) {
        boolean isPositiveStyle = style2.equalsIgnoreCase("Positive");
        boolean isDestructiveStyle = style2.equalsIgnoreCase("Destructive");
        if (isPositiveStyle || isDestructiveStyle) {
            Resources.Theme theme = context.getTheme();
            TypedValue buttonStyle = new TypedValue();
            if (isPositiveStyle) {
                if (theme.resolveAttribute(R.attr.adaptiveActionPositive, buttonStyle, true)) {
                    return ActionElementRenderer.createButtonWithTheme(context, buttonStyle.data);
                }
                Button button = new Button(context);
                button.getBackground().setColorFilter(ActionElementRenderer.getColor(hostConfig.GetForegroundColor(ContainerStyle.Default, ForegroundColor.Accent, false)), PorterDuff.Mode.MULTIPLY);
                return button;
            }
            if (theme.resolveAttribute(R.attr.adaptiveActionDestructive, buttonStyle, true)) {
                return ActionElementRenderer.createButtonWithTheme(context, buttonStyle.data);
            }
            Button button = new Button(context);
            button.setTextColor(ActionElementRenderer.getColor(hostConfig.GetForegroundColor(ContainerStyle.Default, ForegroundColor.Attention, false)));
            return button;
        }
        return new Button(context);
    }

    public Button renderButton(Context context, ViewGroup viewGroup, BaseActionElement baseActionElement, HostConfig hostConfig, RenderedAdaptiveCard renderedCard, RenderArgs renderArgs) {
        LinearLayout.LayoutParams layoutParams;
        TypedValue buttonStyle = new TypedValue();
        if (baseActionElement.GetElementType() == ActionType.ShowCard && context.getTheme().resolveAttribute(R.attr.adaptiveShowCardAction, buttonStyle, true)) {
            context = new ContextThemeWrapper(context, buttonStyle.data);
        }
        Button button = ActionElementRenderer.getButtonForStyle(context, baseActionElement.GetStyle(), hostConfig);
        if (Util.isOfType(baseActionElement, ExecuteAction.class) || Util.isOfType(baseActionElement, SubmitAction.class)) {
            long actionId = Util.getViewId((View)button);
            renderedCard.setCardForSubmitAction(actionId, renderArgs.getContainerCardId());
        }
        button.setText((CharSequence)baseActionElement.GetTitle());
        ActionAlignment alignment = hostConfig.GetActions().getActionAlignment();
        ActionsOrientation orientation = hostConfig.GetActions().getActionsOrientation();
        if (orientation == ActionsOrientation.Horizontal) {
            layoutParams = new LinearLayout.LayoutParams(-2, -1);
            long spacing = hostConfig.GetActions().getButtonSpacing();
            layoutParams.rightMargin = Util.dpToPixels(context, spacing);
        } else {
            layoutParams = new LinearLayout.LayoutParams(-1, -1);
        }
        if (alignment == ActionAlignment.Stretch) {
            layoutParams.weight = 1.0f;
        }
        button.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        String iconUrl = baseActionElement.GetIconUrl();
        if (!iconUrl.isEmpty()) {
            IconPlacement iconPlacement = hostConfig.GetActions().getIconPlacement();
            if (!renderArgs.getAllowAboveTitleIconPlacement()) {
                iconPlacement = IconPlacement.LeftOfTitle;
            }
            ActionElementRendererIconImageLoaderAsync imageLoader = new ActionElementRendererIconImageLoaderAsync(renderedCard, (View)button, hostConfig.GetImageBaseUrl(), iconPlacement, hostConfig.GetActions().getIconSize(), hostConfig.GetSpacing().getDefaultSpacing(), context);
            imageLoader.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[]{baseActionElement.GetIconUrl()});
        }
        viewGroup.addView((View)button);
        return button;
    }

    @Override
    public Button render(RenderedAdaptiveCard renderedCard, Context context, FragmentManager fragmentManager, ViewGroup viewGroup, BaseActionElement baseActionElement, ICardActionHandler cardActionHandler, HostConfig hostConfig, RenderArgs renderArgs) {
        if (cardActionHandler == null) {
            throw new IllegalArgumentException("Action Handler is null.");
        }
        Button button = this.renderButton(context, viewGroup, baseActionElement, hostConfig, renderedCard, renderArgs);
        button.setOnClickListener((View.OnClickListener)new BaseActionElementRenderer.ActionOnClickListener(renderedCard, context, fragmentManager, viewGroup, baseActionElement, cardActionHandler, hostConfig, renderArgs));
        return button;
    }
}

