/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.action;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.Button;
import io.adaptivecards.objectmodel.IconPlacement;
import io.adaptivecards.renderer.InnerImageLoaderAsync;
import io.adaptivecards.renderer.RenderedAdaptiveCard;
import io.adaptivecards.renderer.Util;
import java.lang.ref.WeakReference;

class ActionElementRendererIconImageLoaderAsync
extends InnerImageLoaderAsync {
    private final IconPlacement m_iconPlacement;
    private final long m_iconSize;
    private final long m_padding;
    private final WeakReference<Context> m_context;

    protected ActionElementRendererIconImageLoaderAsync(RenderedAdaptiveCard renderedCard, View containerView, String imageBaseUrl, IconPlacement iconPlacement, long iconSize, long padding, Context context) {
        super(renderedCard, containerView, imageBaseUrl, containerView.getResources().getDisplayMetrics().widthPixels);
        this.m_iconPlacement = iconPlacement;
        this.m_iconSize = iconSize;
        this.m_padding = padding;
        this.m_context = new WeakReference<Context>(context);
    }

    @Override
    public Bitmap styleBitmap(Bitmap bitmap) {
        Button button = (Button)this.m_view;
        float imageHeight = Util.dpToPixels((Context)this.m_context.get(), this.m_iconSize);
        return Util.scaleBitmapToHeight(imageHeight, bitmap);
    }

    @Override
    protected void renderBitmap(Bitmap bitmap) {
        Button button = (Button)this.m_view;
        BitmapDrawable drawableIcon = new BitmapDrawable(null, bitmap);
        Drawable[] drawables = button.getCompoundDrawablesRelative();
        if (this.m_iconPlacement == IconPlacement.AboveTitle) {
            drawables[1] = drawableIcon;
        } else {
            drawables[0] = drawableIcon;
            button.setCompoundDrawablePadding(Util.dpToPixels((Context)this.m_context.get(), (int)this.m_padding));
        }
        button.setCompoundDrawablesRelativeWithIntrinsicBounds(drawables[0], drawables[1], drawables[2], drawables[3]);
    }
}

