/*
 * Decompiled with CFR 0.152.
 */
package io.adaptivecards.renderer.readonly;

import android.graphics.Typeface;
import io.adaptivecards.objectmodel.ContainerStyle;
import io.adaptivecards.objectmodel.FontType;
import io.adaptivecards.objectmodel.ForegroundColor;
import io.adaptivecards.objectmodel.HorizontalAlignment;
import io.adaptivecards.objectmodel.HostConfig;
import io.adaptivecards.objectmodel.TextSize;
import io.adaptivecards.objectmodel.TextWeight;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class TextRendererUtil {
    private static Map<String, Typeface> customTypefaces = new HashMap<String, Typeface>();
    private static HashSet<String> systemFonts = null;
    private static HashSet<String> monospaceSystemFonts = null;
    private static Map<String, Typeface> systemTypefaces = new HashMap<String, Typeface>();
    private static Map<String, String> lightSystemFonts = null;

    public static void registerCustomTypeface(String name, Typeface typeface) {
        customTypefaces.put(name, typeface);
    }

    static boolean fontHasLightVersion(String fontFamily) {
        if (lightSystemFonts == null) {
            lightSystemFonts = new HashMap<String, String>();
            lightSystemFonts.put("sans-serif", "sans-serif-light");
            lightSystemFonts.put("arial", "sans-serif-light");
            lightSystemFonts.put("helvetica", "sans-serif-light");
            lightSystemFonts.put("tahoma", "sans-serif-light");
            lightSystemFonts.put("verdana", "sans-serif-light");
            lightSystemFonts.put("sans-serif-condensed", "sans-serif-condensed-light");
        }
        return lightSystemFonts.containsKey(fontFamily);
    }

    static boolean fontExistsInSystem(String fontFamily) {
        if (systemFonts == null) {
            systemFonts = new HashSet();
            systemFonts.add("sans-serif");
            systemFonts.add("arial");
            systemFonts.add("helvetica");
            systemFonts.add("tahoma");
            systemFonts.add("verdana");
            systemFonts.add("sans-serif-condensed");
            systemFonts.add("serif");
            systemFonts.add("times");
            systemFonts.add("times new roman");
            systemFonts.add("palatino");
            systemFonts.add("georgia");
            systemFonts.add("baskerville");
            systemFonts.add("goudy");
            systemFonts.add("fantasy");
            systemFonts.add("ITC Stone Serif");
            systemFonts.add("casual");
            systemFonts.add("cursive");
            systemFonts.add("sans-serif-smallcaps");
            systemFonts.add("source-sans-pro");
        }
        return systemFonts.contains(fontFamily);
    }

    static boolean fontIsMonospace(String fontFamily) {
        if (monospaceSystemFonts == null) {
            monospaceSystemFonts = new HashSet();
            monospaceSystemFonts.add("sans-serif-monospace");
            monospaceSystemFonts.add("monaco");
            monospaceSystemFonts.add("serif-monospace");
            monospaceSystemFonts.add("courier");
            monospaceSystemFonts.add("courier new");
        }
        return monospaceSystemFonts.contains(fontFamily);
    }

    static Typeface getSystemTypeface(String fontName) {
        if (!systemTypefaces.containsKey(fontName)) {
            systemTypefaces.put(fontName, Typeface.create((String)fontName, (int)0));
        }
        return systemTypefaces.get(fontName);
    }

    static int getTextAlignment(HorizontalAlignment textAlignment) {
        int alignment;
        if (textAlignment == HorizontalAlignment.Center) {
            alignment = 4;
        } else if (textAlignment == HorizontalAlignment.Left) {
            alignment = 5;
        } else if (textAlignment == HorizontalAlignment.Right) {
            alignment = 6;
        } else {
            throw new IllegalArgumentException("Invalid text alignment: " + textAlignment.toString());
        }
        return alignment;
    }

    static long getTextSize(FontType type, TextSize textSize, HostConfig hostConfig) {
        return hostConfig.GetFontSize(type, textSize);
    }

    static String cleanFontFamilyName(String fontFamily) {
        String fontFamilyName = fontFamily.trim();
        if (!fontFamilyName.isEmpty() && fontFamilyName.charAt(0) == '\'') {
            fontFamilyName = fontFamilyName.replace("'", "");
        }
        fontFamilyName = fontFamilyName.toLowerCase();
        return fontFamilyName;
    }

    static Typeface getTextFormat(HostConfig hostConfig, FontType type, boolean isLightWeigthed) {
        String[] fontFamilies = hostConfig.GetFontFamily(type).split(",");
        if (hostConfig.GetFontFamily().isEmpty() && type == FontType.Monospace) {
            return Typeface.MONOSPACE;
        }
        for (String fontFamily : fontFamilies) {
            fontFamily = TextRendererUtil.cleanFontFamilyName(fontFamily);
            String lightFontFamily = fontFamily + "-light";
            if (customTypefaces.containsKey(fontFamily)) {
                return customTypefaces.get(fontFamily);
            }
            if (isLightWeigthed && customTypefaces.containsKey(lightFontFamily)) {
                return customTypefaces.get(lightFontFamily);
            }
            if (!isLightWeigthed && TextRendererUtil.fontExistsInSystem(fontFamily)) {
                return TextRendererUtil.getSystemTypeface(fontFamily);
            }
            if (isLightWeigthed && TextRendererUtil.fontHasLightVersion(fontFamily)) {
                return TextRendererUtil.getSystemTypeface(lightSystemFonts.get(fontFamily));
            }
            if ((!fontFamily.isEmpty() || type != FontType.Monospace) && !TextRendererUtil.fontIsMonospace(fontFamily)) continue;
            return Typeface.MONOSPACE;
        }
        if (isLightWeigthed) {
            return TextRendererUtil.getSystemTypeface("sans-serif-light");
        }
        return Typeface.create((String)null, (int)0);
    }

    static String getTextColor(ForegroundColor foregroundColor, HostConfig hostConfig, boolean isSubtle, ContainerStyle containerStyle) {
        return hostConfig.GetForegroundColor(containerStyle, foregroundColor, isSubtle);
    }

    static String getHighlightColor(ForegroundColor foregroundColor, HostConfig hostConfig, boolean isSubtle, ContainerStyle containerStyle) {
        return hostConfig.GetHighlightColor(containerStyle, foregroundColor, isSubtle);
    }

    static int getTextWeight(TextWeight textWeight) {
        int weight;
        if (textWeight == TextWeight.Default) {
            weight = 0;
        } else if (textWeight == TextWeight.Bolder) {
            weight = 1;
        } else if (textWeight == TextWeight.Lighter) {
            weight = 0;
        } else {
            throw new IllegalArgumentException("Invalid text weight: " + textWeight.toString());
        }
        return weight;
    }
}

